/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface;

public class DescribeLocalGatewayVirtualInterfacesPublisher
implements SdkPublisher<DescribeLocalGatewayVirtualInterfacesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeLocalGatewayVirtualInterfacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLocalGatewayVirtualInterfacesPublisher(Ec2AsyncClient client, DescribeLocalGatewayVirtualInterfacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLocalGatewayVirtualInterfacesPublisher(Ec2AsyncClient client, DescribeLocalGatewayVirtualInterfacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLocalGatewayVirtualInterfacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLocalGatewayVirtualInterfacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces() {
        Function<DescribeLocalGatewayVirtualInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.localGatewayVirtualInterfaces() != null) {
                return response.localGatewayVirtualInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLocalGatewayVirtualInterfacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeLocalGatewayVirtualInterfacesResponseFetcher
    implements AsyncPageFetcher<DescribeLocalGatewayVirtualInterfacesResponse> {
        private DescribeLocalGatewayVirtualInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewayVirtualInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLocalGatewayVirtualInterfacesResponse> nextPage(DescribeLocalGatewayVirtualInterfacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewayVirtualInterfacesPublisher.this.client.describeLocalGatewayVirtualInterfaces(DescribeLocalGatewayVirtualInterfacesPublisher.this.firstRequest);
            }
            return DescribeLocalGatewayVirtualInterfacesPublisher.this.client.describeLocalGatewayVirtualInterfaces((DescribeLocalGatewayVirtualInterfacesRequest)((Object)DescribeLocalGatewayVirtualInterfacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

