/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaGlobalSecondaryIndexSettingsDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsDescription> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(ReplicaGlobalSecondaryIndexSettingsDescription.getter(ReplicaGlobalSecondaryIndexSettingsDescription::indexName)).setter(ReplicaGlobalSecondaryIndexSettingsDescription.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(ReplicaGlobalSecondaryIndexSettingsDescription.getter(ReplicaGlobalSecondaryIndexSettingsDescription::indexStatusAsString)).setter(ReplicaGlobalSecondaryIndexSettingsDescription.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<Long> PROVISIONED_READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProvisionedReadCapacityUnits").getter(ReplicaGlobalSecondaryIndexSettingsDescription.getter(ReplicaGlobalSecondaryIndexSettingsDescription::provisionedReadCapacityUnits)).setter(ReplicaGlobalSecondaryIndexSettingsDescription.setter(Builder::provisionedReadCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedReadCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettingsDescription> PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedReadCapacityAutoScalingSettings").getter(ReplicaGlobalSecondaryIndexSettingsDescription.getter(ReplicaGlobalSecondaryIndexSettingsDescription::provisionedReadCapacityAutoScalingSettings)).setter(ReplicaGlobalSecondaryIndexSettingsDescription.setter(Builder::provisionedReadCapacityAutoScalingSettings)).constructor(AutoScalingSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedReadCapacityAutoScalingSettings").build()}).build();
    private static final SdkField<Long> PROVISIONED_WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProvisionedWriteCapacityUnits").getter(ReplicaGlobalSecondaryIndexSettingsDescription.getter(ReplicaGlobalSecondaryIndexSettingsDescription::provisionedWriteCapacityUnits)).setter(ReplicaGlobalSecondaryIndexSettingsDescription.setter(Builder::provisionedWriteCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedWriteCapacityUnits").build()}).build();
    private static final SdkField<AutoScalingSettingsDescription> PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedWriteCapacityAutoScalingSettings").getter(ReplicaGlobalSecondaryIndexSettingsDescription.getter(ReplicaGlobalSecondaryIndexSettingsDescription::provisionedWriteCapacityAutoScalingSettings)).setter(ReplicaGlobalSecondaryIndexSettingsDescription.setter(Builder::provisionedWriteCapacityAutoScalingSettings)).constructor(AutoScalingSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedWriteCapacityAutoScalingSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, INDEX_STATUS_FIELD, PROVISIONED_READ_CAPACITY_UNITS_FIELD, PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, PROVISIONED_WRITE_CAPACITY_UNITS_FIELD, PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicaGlobalSecondaryIndexSettingsDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final String indexStatus;
    private final Long provisionedReadCapacityUnits;
    private final AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings;
    private final Long provisionedWriteCapacityUnits;
    private final AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings;

    private ReplicaGlobalSecondaryIndexSettingsDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.indexStatus = builder.indexStatus;
        this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
        this.provisionedReadCapacityAutoScalingSettings = builder.provisionedReadCapacityAutoScalingSettings;
        this.provisionedWriteCapacityUnits = builder.provisionedWriteCapacityUnits;
        this.provisionedWriteCapacityAutoScalingSettings = builder.provisionedWriteCapacityAutoScalingSettings;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final Long provisionedReadCapacityUnits() {
        return this.provisionedReadCapacityUnits;
    }

    public final AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings() {
        return this.provisionedReadCapacityAutoScalingSettings;
    }

    public final Long provisionedWriteCapacityUnits() {
        return this.provisionedWriteCapacityUnits;
    }

    public final AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings() {
        return this.provisionedWriteCapacityAutoScalingSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedReadCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedWriteCapacityAutoScalingSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexSettingsDescription)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexSettingsDescription other = (ReplicaGlobalSecondaryIndexSettingsDescription)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.provisionedReadCapacityUnits(), other.provisionedReadCapacityUnits()) && Objects.equals(this.provisionedReadCapacityAutoScalingSettings(), other.provisionedReadCapacityAutoScalingSettings()) && Objects.equals(this.provisionedWriteCapacityUnits(), other.provisionedWriteCapacityUnits()) && Objects.equals(this.provisionedWriteCapacityAutoScalingSettings(), other.provisionedWriteCapacityAutoScalingSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaGlobalSecondaryIndexSettingsDescription").add("IndexName", (Object)this.indexName()).add("IndexStatus", (Object)this.indexStatusAsString()).add("ProvisionedReadCapacityUnits", (Object)this.provisionedReadCapacityUnits()).add("ProvisionedReadCapacityAutoScalingSettings", (Object)this.provisionedReadCapacityAutoScalingSettings()).add("ProvisionedWriteCapacityUnits", (Object)this.provisionedWriteCapacityUnits()).add("ProvisionedWriteCapacityAutoScalingSettings", (Object)this.provisionedWriteCapacityAutoScalingSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "ProvisionedReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedReadCapacityUnits()));
            }
            case "ProvisionedReadCapacityAutoScalingSettings": {
                return Optional.ofNullable(clazz.cast(this.provisionedReadCapacityAutoScalingSettings()));
            }
            case "ProvisionedWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.provisionedWriteCapacityUnits()));
            }
            case "ProvisionedWriteCapacityAutoScalingSettings": {
                return Optional.ofNullable(clazz.cast(this.provisionedWriteCapacityAutoScalingSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("ProvisionedReadCapacityUnits", PROVISIONED_READ_CAPACITY_UNITS_FIELD);
        map.put("ProvisionedReadCapacityAutoScalingSettings", PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD);
        map.put("ProvisionedWriteCapacityUnits", PROVISIONED_WRITE_CAPACITY_UNITS_FIELD);
        map.put("ProvisionedWriteCapacityAutoScalingSettings", PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaGlobalSecondaryIndexSettingsDescription, T> g) {
        return obj -> g.apply((ReplicaGlobalSecondaryIndexSettingsDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private String indexStatus;
        private Long provisionedReadCapacityUnits;
        private AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings;
        private Long provisionedWriteCapacityUnits;
        private AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexSettingsDescription model) {
            this.indexName(model.indexName);
            this.indexStatus(model.indexStatus);
            this.provisionedReadCapacityUnits(model.provisionedReadCapacityUnits);
            this.provisionedReadCapacityAutoScalingSettings(model.provisionedReadCapacityAutoScalingSettings);
            this.provisionedWriteCapacityUnits(model.provisionedWriteCapacityUnits);
            this.provisionedWriteCapacityAutoScalingSettings(model.provisionedWriteCapacityAutoScalingSettings);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final Long getProvisionedReadCapacityUnits() {
            return this.provisionedReadCapacityUnits;
        }

        public final void setProvisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }

        @Override
        public final Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
            return this;
        }

        public final AutoScalingSettingsDescription.Builder getProvisionedReadCapacityAutoScalingSettings() {
            return this.provisionedReadCapacityAutoScalingSettings != null ? this.provisionedReadCapacityAutoScalingSettings.toBuilder() : null;
        }

        public final void setProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription.BuilderImpl provisionedReadCapacityAutoScalingSettings) {
            this.provisionedReadCapacityAutoScalingSettings = provisionedReadCapacityAutoScalingSettings != null ? provisionedReadCapacityAutoScalingSettings.build() : null;
        }

        @Override
        public final Builder provisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription provisionedReadCapacityAutoScalingSettings) {
            this.provisionedReadCapacityAutoScalingSettings = provisionedReadCapacityAutoScalingSettings;
            return this;
        }

        public final Long getProvisionedWriteCapacityUnits() {
            return this.provisionedWriteCapacityUnits;
        }

        public final void setProvisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
        }

        @Override
        public final Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
            return this;
        }

        public final AutoScalingSettingsDescription.Builder getProvisionedWriteCapacityAutoScalingSettings() {
            return this.provisionedWriteCapacityAutoScalingSettings != null ? this.provisionedWriteCapacityAutoScalingSettings.toBuilder() : null;
        }

        public final void setProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription.BuilderImpl provisionedWriteCapacityAutoScalingSettings) {
            this.provisionedWriteCapacityAutoScalingSettings = provisionedWriteCapacityAutoScalingSettings != null ? provisionedWriteCapacityAutoScalingSettings.build() : null;
        }

        @Override
        public final Builder provisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription provisionedWriteCapacityAutoScalingSettings) {
            this.provisionedWriteCapacityAutoScalingSettings = provisionedWriteCapacityAutoScalingSettings;
            return this;
        }

        public ReplicaGlobalSecondaryIndexSettingsDescription build() {
            return new ReplicaGlobalSecondaryIndexSettingsDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsDescription> {
        public Builder indexName(String var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder provisionedReadCapacityUnits(Long var1);

        public Builder provisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription var1);

        default public Builder provisionedReadCapacityAutoScalingSettings(Consumer<AutoScalingSettingsDescription.Builder> provisionedReadCapacityAutoScalingSettings) {
            return this.provisionedReadCapacityAutoScalingSettings((AutoScalingSettingsDescription)((AutoScalingSettingsDescription.Builder)AutoScalingSettingsDescription.builder().applyMutation(provisionedReadCapacityAutoScalingSettings)).build());
        }

        public Builder provisionedWriteCapacityUnits(Long var1);

        public Builder provisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription var1);

        default public Builder provisionedWriteCapacityAutoScalingSettings(Consumer<AutoScalingSettingsDescription.Builder> provisionedWriteCapacityAutoScalingSettings) {
            return this.provisionedWriteCapacityAutoScalingSettings((AutoScalingSettingsDescription)((AutoScalingSettingsDescription.Builder)AutoScalingSettingsDescription.builder().applyMutation(provisionedWriteCapacityAutoScalingSettings)).build());
        }
    }
}

