/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableFromBackupRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, RestoreTableFromBackupRequest> {
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetTableName").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::targetTableName)).setter(RestoreTableFromBackupRequest.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()}).build();
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupArn").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::backupArn)).setter(RestoreTableFromBackupRequest.setter(Builder::backupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()}).build();
    private static final SdkField<String> BILLING_MODE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingModeOverride").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::billingModeOverrideAsString)).setter(RestoreTableFromBackupRequest.setter(Builder::billingModeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeOverride").build()}).build();
    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexOverride").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::globalSecondaryIndexOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::globalSecondaryIndexOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalSecondaryIndexOverride").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::localSecondaryIndexOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::localSecondaryIndexOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::provisionedThroughputOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<OnDemandThroughput> ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandThroughputOverride").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::onDemandThroughputOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::onDemandThroughputOverride)).constructor(OnDemandThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughputOverride").build()}).build();
    private static final SdkField<SSESpecification> SSE_SPECIFICATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSESpecificationOverride").getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::sseSpecificationOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::sseSpecificationOverride)).constructor(SSESpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecificationOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TABLE_NAME_FIELD, BACKUP_ARN_FIELD, BILLING_MODE_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD, LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD, SSE_SPECIFICATION_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreTableFromBackupRequest.memberNameToFieldInitializer();
    private final String targetTableName;
    private final String backupArn;
    private final String billingModeOverride;
    private final List<GlobalSecondaryIndex> globalSecondaryIndexOverride;
    private final List<LocalSecondaryIndex> localSecondaryIndexOverride;
    private final ProvisionedThroughput provisionedThroughputOverride;
    private final OnDemandThroughput onDemandThroughputOverride;
    private final SSESpecification sseSpecificationOverride;

    private RestoreTableFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.targetTableName = builder.targetTableName;
        this.backupArn = builder.backupArn;
        this.billingModeOverride = builder.billingModeOverride;
        this.globalSecondaryIndexOverride = builder.globalSecondaryIndexOverride;
        this.localSecondaryIndexOverride = builder.localSecondaryIndexOverride;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.onDemandThroughputOverride = builder.onDemandThroughputOverride;
        this.sseSpecificationOverride = builder.sseSpecificationOverride;
    }

    public final String targetTableName() {
        return this.targetTableName;
    }

    public final String backupArn() {
        return this.backupArn;
    }

    public final BillingMode billingModeOverride() {
        return BillingMode.fromValue(this.billingModeOverride);
    }

    public final String billingModeOverrideAsString() {
        return this.billingModeOverride;
    }

    public final boolean hasGlobalSecondaryIndexOverride() {
        return this.globalSecondaryIndexOverride != null && !(this.globalSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    public final List<GlobalSecondaryIndex> globalSecondaryIndexOverride() {
        return this.globalSecondaryIndexOverride;
    }

    public final boolean hasLocalSecondaryIndexOverride() {
        return this.localSecondaryIndexOverride != null && !(this.localSecondaryIndexOverride instanceof SdkAutoConstructList);
    }

    public final List<LocalSecondaryIndex> localSecondaryIndexOverride() {
        return this.localSecondaryIndexOverride;
    }

    public final ProvisionedThroughput provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public final OnDemandThroughput onDemandThroughputOverride() {
        return this.onDemandThroughputOverride;
    }

    public final SSESpecification sseSpecificationOverride() {
        return this.sseSpecificationOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexOverride() ? this.globalSecondaryIndexOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalSecondaryIndexOverride() ? this.localSecondaryIndexOverride() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecificationOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromBackupRequest)) {
            return false;
        }
        RestoreTableFromBackupRequest other = (RestoreTableFromBackupRequest)((Object)obj);
        return Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.backupArn(), other.backupArn()) && Objects.equals(this.billingModeOverrideAsString(), other.billingModeOverrideAsString()) && this.hasGlobalSecondaryIndexOverride() == other.hasGlobalSecondaryIndexOverride() && Objects.equals(this.globalSecondaryIndexOverride(), other.globalSecondaryIndexOverride()) && this.hasLocalSecondaryIndexOverride() == other.hasLocalSecondaryIndexOverride() && Objects.equals(this.localSecondaryIndexOverride(), other.localSecondaryIndexOverride()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.onDemandThroughputOverride(), other.onDemandThroughputOverride()) && Objects.equals(this.sseSpecificationOverride(), other.sseSpecificationOverride());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreTableFromBackupRequest").add("TargetTableName", (Object)this.targetTableName()).add("BackupArn", (Object)this.backupArn()).add("BillingModeOverride", (Object)this.billingModeOverrideAsString()).add("GlobalSecondaryIndexOverride", this.hasGlobalSecondaryIndexOverride() ? this.globalSecondaryIndexOverride() : null).add("LocalSecondaryIndexOverride", this.hasLocalSecondaryIndexOverride() ? this.localSecondaryIndexOverride() : null).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("OnDemandThroughputOverride", (Object)this.onDemandThroughputOverride()).add("SSESpecificationOverride", (Object)this.sseSpecificationOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
            case "BillingModeOverride": {
                return Optional.ofNullable(clazz.cast(this.billingModeOverrideAsString()));
            }
            case "GlobalSecondaryIndexOverride": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexOverride()));
            }
            case "LocalSecondaryIndexOverride": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexOverride()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "OnDemandThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.onDemandThroughputOverride()));
            }
            case "SSESpecificationOverride": {
                return Optional.ofNullable(clazz.cast(this.sseSpecificationOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetTableName", TARGET_TABLE_NAME_FIELD);
        map.put("BackupArn", BACKUP_ARN_FIELD);
        map.put("BillingModeOverride", BILLING_MODE_OVERRIDE_FIELD);
        map.put("GlobalSecondaryIndexOverride", GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD);
        map.put("LocalSecondaryIndexOverride", LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD);
        map.put("ProvisionedThroughputOverride", PROVISIONED_THROUGHPUT_OVERRIDE_FIELD);
        map.put("OnDemandThroughputOverride", ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD);
        map.put("SSESpecificationOverride", SSE_SPECIFICATION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromBackupRequest, T> g) {
        return obj -> g.apply((RestoreTableFromBackupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String targetTableName;
        private String backupArn;
        private String billingModeOverride;
        private List<GlobalSecondaryIndex> globalSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();
        private List<LocalSecondaryIndex> localSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();
        private ProvisionedThroughput provisionedThroughputOverride;
        private OnDemandThroughput onDemandThroughputOverride;
        private SSESpecification sseSpecificationOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromBackupRequest model) {
            super(model);
            this.targetTableName(model.targetTableName);
            this.backupArn(model.backupArn);
            this.billingModeOverride(model.billingModeOverride);
            this.globalSecondaryIndexOverride(model.globalSecondaryIndexOverride);
            this.localSecondaryIndexOverride(model.localSecondaryIndexOverride);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.onDemandThroughputOverride(model.onDemandThroughputOverride);
            this.sseSpecificationOverride(model.sseSpecificationOverride);
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final String getBillingModeOverride() {
            return this.billingModeOverride;
        }

        public final void setBillingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
        }

        @Override
        public final Builder billingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
            return this;
        }

        @Override
        public final Builder billingModeOverride(BillingMode billingModeOverride) {
            this.billingModeOverride(billingModeOverride == null ? null : billingModeOverride.toString());
            return this;
        }

        public final List<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexOverride() {
            List<GlobalSecondaryIndex.Builder> result = GlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexOverride(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexOverride);
        }

        @Override
        public final Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(GlobalSecondaryIndex ... globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride(Arrays.asList(globalSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder> ... globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride(Stream.of(globalSecondaryIndexOverride).map(c -> (GlobalSecondaryIndex)((GlobalSecondaryIndex.Builder)GlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LocalSecondaryIndex.Builder> getLocalSecondaryIndexOverride() {
            List<LocalSecondaryIndex.Builder> result = LocalSecondaryIndexListCopier.copyToBuilder(this.localSecondaryIndexOverride);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalSecondaryIndexOverride(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexOverride);
        }

        @Override
        public final Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copy(localSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(LocalSecondaryIndex ... localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride(Arrays.asList(localSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder> ... localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride(Stream.of(localSecondaryIndexOverride).map(c -> (LocalSecondaryIndex)((LocalSecondaryIndex.Builder)LocalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughput.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughput provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final OnDemandThroughput.Builder getOnDemandThroughputOverride() {
            return this.onDemandThroughputOverride != null ? this.onDemandThroughputOverride.toBuilder() : null;
        }

        public final void setOnDemandThroughputOverride(OnDemandThroughput.BuilderImpl onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride != null ? onDemandThroughputOverride.build() : null;
        }

        @Override
        public final Builder onDemandThroughputOverride(OnDemandThroughput onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride;
            return this;
        }

        public final SSESpecification.Builder getSseSpecificationOverride() {
            return this.sseSpecificationOverride != null ? this.sseSpecificationOverride.toBuilder() : null;
        }

        public final void setSseSpecificationOverride(SSESpecification.BuilderImpl sseSpecificationOverride) {
            this.sseSpecificationOverride = sseSpecificationOverride != null ? sseSpecificationOverride.build() : null;
        }

        @Override
        public final Builder sseSpecificationOverride(SSESpecification sseSpecificationOverride) {
            this.sseSpecificationOverride = sseSpecificationOverride;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromBackupRequest build() {
            return new RestoreTableFromBackupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreTableFromBackupRequest> {
        public Builder targetTableName(String var1);

        public Builder backupArn(String var1);

        public Builder billingModeOverride(String var1);

        public Builder billingModeOverride(BillingMode var1);

        public Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexOverride(GlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder> ... var1);

        public Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> var1);

        public Builder localSecondaryIndexOverride(LocalSecondaryIndex ... var1);

        public Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder> ... var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughput var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughput.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder onDemandThroughputOverride(OnDemandThroughput var1);

        default public Builder onDemandThroughputOverride(Consumer<OnDemandThroughput.Builder> onDemandThroughputOverride) {
            return this.onDemandThroughputOverride((OnDemandThroughput)((OnDemandThroughput.Builder)OnDemandThroughput.builder().applyMutation(onDemandThroughputOverride)).build());
        }

        public Builder sseSpecificationOverride(SSESpecification var1);

        default public Builder sseSpecificationOverride(Consumer<SSESpecification.Builder> sseSpecificationOverride) {
            return this.sseSpecificationOverride((SSESpecification)((SSESpecification.Builder)SSESpecification.builder().applyMutation(sseSpecificationOverride)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

