/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTableResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, DescribeTableResponse> {
    private static final SdkField<TableDescription> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Table").getter(DescribeTableResponse.getter(DescribeTableResponse::table)).setter(DescribeTableResponse.setter(Builder::table)).constructor(TableDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Table", TABLE_FIELD);
        }
    });
    private final TableDescription table;

    private DescribeTableResponse(BuilderImpl builder) {
        super(builder);
        this.table = builder.table;
    }

    public final TableDescription table() {
        return this.table;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableResponse)) {
            return false;
        }
        DescribeTableResponse other = (DescribeTableResponse)((Object)obj);
        return Objects.equals(this.table(), other.table());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTableResponse").add("Table", (Object)this.table()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableResponse, T> g) {
        return obj -> g.apply((DescribeTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private TableDescription table;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableResponse model) {
            super(model);
            this.table(model.table);
        }

        public final TableDescription.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(TableDescription.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(TableDescription table) {
            this.table = table;
            return this;
        }

        @Override
        public DescribeTableResponse build() {
            return new DescribeTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTableResponse> {
        public Builder table(TableDescription var1);

        default public Builder table(Consumer<TableDescription.Builder> table) {
            return this.table((TableDescription)((TableDescription.Builder)TableDescription.builder().applyMutation(table)).build());
        }
    }
}

