/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the DynamoDB Streams configuration for a table in DynamoDB.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamSpecification.Builder, StreamSpecification> {
    private static final SdkField<Boolean> STREAM_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StreamEnabled").getter(getter(StreamSpecification::streamEnabled))
            .setter(setter(Builder::streamEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamEnabled").build()).build();

    private static final SdkField<String> STREAM_VIEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamViewType").getter(getter(StreamSpecification::streamViewTypeAsString))
            .setter(setter(Builder::streamViewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamViewType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ENABLED_FIELD,
            STREAM_VIEW_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean streamEnabled;

    private final String streamViewType;

    private StreamSpecification(BuilderImpl builder) {
        this.streamEnabled = builder.streamEnabled;
        this.streamViewType = builder.streamViewType;
    }

    /**
     * <p>
     * Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.
     * </p>
     * 
     * @return Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.
     */
    public final Boolean streamEnabled() {
        return streamEnabled;
    }

    /**
     * <p>
     * When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the
     * stream for this table. Valid values for <code>StreamViewType</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamViewType}
     * will return {@link StreamViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamViewTypeAsString}.
     * </p>
     * 
     * @return When an item in the table is modified, <code>StreamViewType</code> determines what information is written
     *         to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
     *         stream.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public final StreamViewType streamViewType() {
        return StreamViewType.fromValue(streamViewType);
    }

    /**
     * <p>
     * When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the
     * stream for this table. Valid values for <code>StreamViewType</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamViewType}
     * will return {@link StreamViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamViewTypeAsString}.
     * </p>
     * 
     * @return When an item in the table is modified, <code>StreamViewType</code> determines what information is written
     *         to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
     *         stream.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public final String streamViewTypeAsString() {
        return streamViewType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(streamViewTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSpecification)) {
            return false;
        }
        StreamSpecification other = (StreamSpecification) obj;
        return Objects.equals(streamEnabled(), other.streamEnabled())
                && Objects.equals(streamViewTypeAsString(), other.streamViewTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamSpecification").add("StreamEnabled", streamEnabled())
                .add("StreamViewType", streamViewTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamEnabled":
            return Optional.ofNullable(clazz.cast(streamEnabled()));
        case "StreamViewType":
            return Optional.ofNullable(clazz.cast(streamViewTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSpecification, T> g) {
        return obj -> g.apply((StreamSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamSpecification> {
        /**
         * <p>
         * Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.
         * </p>
         * 
         * @param streamEnabled
         *        Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamEnabled(Boolean streamEnabled);

        /**
         * <p>
         * When an item in the table is modified, <code>StreamViewType</code> determines what information is written to
         * the stream for this table. Valid values for <code>StreamViewType</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        When an item in the table is modified, <code>StreamViewType</code> determines what information is
         *        written to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
         *        stream.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(String streamViewType);

        /**
         * <p>
         * When an item in the table is modified, <code>StreamViewType</code> determines what information is written to
         * the stream for this table. Valid values for <code>StreamViewType</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        When an item in the table is modified, <code>StreamViewType</code> determines what information is
         *        written to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
         *        stream.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(StreamViewType streamViewType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean streamEnabled;

        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSpecification model) {
            streamEnabled(model.streamEnabled);
            streamViewType(model.streamViewType);
        }

        public final Boolean getStreamEnabled() {
            return streamEnabled;
        }

        public final void setStreamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
        }

        @Override
        public final Builder streamEnabled(Boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
            return this;
        }

        public final String getStreamViewType() {
            return streamViewType;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType == null ? null : streamViewType.toString());
            return this;
        }

        @Override
        public StreamSpecification build() {
            return new StreamSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
