/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A PartiQL batch statement response..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStatementResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchStatementResponse.Builder, BatchStatementResponse> {
    private static final SdkField<BatchStatementError> ERROR_FIELD = SdkField
            .<BatchStatementError> builder(MarshallingType.SDK_POJO).memberName("Error")
            .getter(getter(BatchStatementResponse::error)).setter(setter(Builder::error))
            .constructor(BatchStatementError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(BatchStatementResponse::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Item")
            .getter(getter(BatchStatementResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, TABLE_NAME_FIELD,
            ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchStatementError error;

    private final String tableName;

    private final Map<String, AttributeValue> item;

    private BatchStatementResponse(BuilderImpl builder) {
        this.error = builder.error;
        this.tableName = builder.tableName;
        this.item = builder.item;
    }

    /**
     * <p>
     * The error associated with a failed PartiQL batch statement.
     * </p>
     * 
     * @return The error associated with a failed PartiQL batch statement.
     */
    public final BatchStatementError error() {
        return error;
    }

    /**
     * <p>
     * The table name associated with a failed PartiQL batch statement.
     * </p>
     * 
     * @return The table name associated with a failed PartiQL batch statement.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Item property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A DynamoDB item associated with a BatchStatementResponse
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItem} method.
     * </p>
     * 
     * @return A DynamoDB item associated with a BatchStatementResponse
     */
    public final Map<String, AttributeValue> item() {
        return item;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasItem() ? item() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStatementResponse)) {
            return false;
        }
        BatchStatementResponse other = (BatchStatementResponse) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(tableName(), other.tableName())
                && hasItem() == other.hasItem() && Objects.equals(item(), other.item());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStatementResponse").add("Error", error()).add("TableName", tableName())
                .add("Item", hasItem() ? item() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStatementResponse, T> g) {
        return obj -> g.apply((BatchStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchStatementResponse> {
        /**
         * <p>
         * The error associated with a failed PartiQL batch statement.
         * </p>
         * 
         * @param error
         *        The error associated with a failed PartiQL batch statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(BatchStatementError error);

        /**
         * <p>
         * The error associated with a failed PartiQL batch statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchStatementError.Builder} avoiding the
         * need to create one manually via {@link BatchStatementError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchStatementError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(BatchStatementError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link BatchStatementError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(BatchStatementError)
         */
        default Builder error(Consumer<BatchStatementError.Builder> error) {
            return error(BatchStatementError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The table name associated with a failed PartiQL batch statement.
         * </p>
         * 
         * @param tableName
         *        The table name associated with a failed PartiQL batch statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A DynamoDB item associated with a BatchStatementResponse
         * </p>
         * 
         * @param item
         *        A DynamoDB item associated with a BatchStatementResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Map<String, AttributeValue> item);
    }

    static final class BuilderImpl implements Builder {
        private BatchStatementError error;

        private String tableName;

        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStatementResponse model) {
            error(model.error);
            tableName(model.tableName);
            item(model.item);
        }

        public final BatchStatementError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(BatchStatementError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(BatchStatementError error) {
            this.error = error;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            Map<String, AttributeValue.Builder> result = AttributeMapCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = AttributeMapCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = AttributeMapCopier.copy(item);
            return this;
        }

        @Override
        public BatchStatementResponse build() {
            return new BatchStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
