/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the Source Server Lifecycle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycle implements SdkPojo, Serializable, ToCopyableBuilder<LifeCycle.Builder, LifeCycle> {
    private static final SdkField<String> ADDED_TO_SERVICE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addedToServiceDateTime").getter(getter(LifeCycle::addedToServiceDateTime))
            .setter(setter(Builder::addedToServiceDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addedToServiceDateTime").build())
            .build();

    private static final SdkField<String> ELAPSED_REPLICATION_DURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("elapsedReplicationDuration")
            .getter(getter(LifeCycle::elapsedReplicationDuration))
            .setter(setter(Builder::elapsedReplicationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsedReplicationDuration").build())
            .build();

    private static final SdkField<String> FIRST_BYTE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstByteDateTime").getter(getter(LifeCycle::firstByteDateTime))
            .setter(setter(Builder::firstByteDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstByteDateTime").build()).build();

    private static final SdkField<LifeCycleLastLaunch> LAST_LAUNCH_FIELD = SdkField
            .<LifeCycleLastLaunch> builder(MarshallingType.SDK_POJO).memberName("lastLaunch")
            .getter(getter(LifeCycle::lastLaunch)).setter(setter(Builder::lastLaunch)).constructor(LifeCycleLastLaunch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLaunch").build()).build();

    private static final SdkField<String> LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("lastSeenByServiceDateTime")
            .getter(getter(LifeCycle::lastSeenByServiceDateTime)).setter(setter(Builder::lastSeenByServiceDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeenByServiceDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDED_TO_SERVICE_DATE_TIME_FIELD, ELAPSED_REPLICATION_DURATION_FIELD, FIRST_BYTE_DATE_TIME_FIELD, LAST_LAUNCH_FIELD,
            LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addedToServiceDateTime;

    private final String elapsedReplicationDuration;

    private final String firstByteDateTime;

    private final LifeCycleLastLaunch lastLaunch;

    private final String lastSeenByServiceDateTime;

    private LifeCycle(BuilderImpl builder) {
        this.addedToServiceDateTime = builder.addedToServiceDateTime;
        this.elapsedReplicationDuration = builder.elapsedReplicationDuration;
        this.firstByteDateTime = builder.firstByteDateTime;
        this.lastLaunch = builder.lastLaunch;
        this.lastSeenByServiceDateTime = builder.lastSeenByServiceDateTime;
    }

    /**
     * <p>
     * The date and time of when the Source Server was added to the service.
     * </p>
     * 
     * @return The date and time of when the Source Server was added to the service.
     */
    public final String addedToServiceDateTime() {
        return addedToServiceDateTime;
    }

    /**
     * <p>
     * The amount of time that the Source Server has been replicating for.
     * </p>
     * 
     * @return The amount of time that the Source Server has been replicating for.
     */
    public final String elapsedReplicationDuration() {
        return elapsedReplicationDuration;
    }

    /**
     * <p>
     * The date and time of the first byte that was replicated from the Source Server.
     * </p>
     * 
     * @return The date and time of the first byte that was replicated from the Source Server.
     */
    public final String firstByteDateTime() {
        return firstByteDateTime;
    }

    /**
     * <p>
     * An object containing information regarding the last launch of the Source Server.
     * </p>
     * 
     * @return An object containing information regarding the last launch of the Source Server.
     */
    public final LifeCycleLastLaunch lastLaunch() {
        return lastLaunch;
    }

    /**
     * <p>
     * The date and time this Source Server was last seen by the service.
     * </p>
     * 
     * @return The date and time this Source Server was last seen by the service.
     */
    public final String lastSeenByServiceDateTime() {
        return lastSeenByServiceDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addedToServiceDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedReplicationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(firstByteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeenByServiceDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycle)) {
            return false;
        }
        LifeCycle other = (LifeCycle) obj;
        return Objects.equals(addedToServiceDateTime(), other.addedToServiceDateTime())
                && Objects.equals(elapsedReplicationDuration(), other.elapsedReplicationDuration())
                && Objects.equals(firstByteDateTime(), other.firstByteDateTime())
                && Objects.equals(lastLaunch(), other.lastLaunch())
                && Objects.equals(lastSeenByServiceDateTime(), other.lastSeenByServiceDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycle").add("AddedToServiceDateTime", addedToServiceDateTime())
                .add("ElapsedReplicationDuration", elapsedReplicationDuration()).add("FirstByteDateTime", firstByteDateTime())
                .add("LastLaunch", lastLaunch()).add("LastSeenByServiceDateTime", lastSeenByServiceDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addedToServiceDateTime":
            return Optional.ofNullable(clazz.cast(addedToServiceDateTime()));
        case "elapsedReplicationDuration":
            return Optional.ofNullable(clazz.cast(elapsedReplicationDuration()));
        case "firstByteDateTime":
            return Optional.ofNullable(clazz.cast(firstByteDateTime()));
        case "lastLaunch":
            return Optional.ofNullable(clazz.cast(lastLaunch()));
        case "lastSeenByServiceDateTime":
            return Optional.ofNullable(clazz.cast(lastSeenByServiceDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifeCycle, T> g) {
        return obj -> g.apply((LifeCycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycle> {
        /**
         * <p>
         * The date and time of when the Source Server was added to the service.
         * </p>
         * 
         * @param addedToServiceDateTime
         *        The date and time of when the Source Server was added to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedToServiceDateTime(String addedToServiceDateTime);

        /**
         * <p>
         * The amount of time that the Source Server has been replicating for.
         * </p>
         * 
         * @param elapsedReplicationDuration
         *        The amount of time that the Source Server has been replicating for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedReplicationDuration(String elapsedReplicationDuration);

        /**
         * <p>
         * The date and time of the first byte that was replicated from the Source Server.
         * </p>
         * 
         * @param firstByteDateTime
         *        The date and time of the first byte that was replicated from the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstByteDateTime(String firstByteDateTime);

        /**
         * <p>
         * An object containing information regarding the last launch of the Source Server.
         * </p>
         * 
         * @param lastLaunch
         *        An object containing information regarding the last launch of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastLaunch(LifeCycleLastLaunch lastLaunch);

        /**
         * <p>
         * An object containing information regarding the last launch of the Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleLastLaunch.Builder} avoiding the
         * need to create one manually via {@link LifeCycleLastLaunch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycleLastLaunch.Builder#build()} is called immediately and
         * its result is passed to {@link #lastLaunch(LifeCycleLastLaunch)}.
         * 
         * @param lastLaunch
         *        a consumer that will call methods on {@link LifeCycleLastLaunch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastLaunch(LifeCycleLastLaunch)
         */
        default Builder lastLaunch(Consumer<LifeCycleLastLaunch.Builder> lastLaunch) {
            return lastLaunch(LifeCycleLastLaunch.builder().applyMutation(lastLaunch).build());
        }

        /**
         * <p>
         * The date and time this Source Server was last seen by the service.
         * </p>
         * 
         * @param lastSeenByServiceDateTime
         *        The date and time this Source Server was last seen by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeenByServiceDateTime(String lastSeenByServiceDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String addedToServiceDateTime;

        private String elapsedReplicationDuration;

        private String firstByteDateTime;

        private LifeCycleLastLaunch lastLaunch;

        private String lastSeenByServiceDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycle model) {
            addedToServiceDateTime(model.addedToServiceDateTime);
            elapsedReplicationDuration(model.elapsedReplicationDuration);
            firstByteDateTime(model.firstByteDateTime);
            lastLaunch(model.lastLaunch);
            lastSeenByServiceDateTime(model.lastSeenByServiceDateTime);
        }

        public final String getAddedToServiceDateTime() {
            return addedToServiceDateTime;
        }

        public final void setAddedToServiceDateTime(String addedToServiceDateTime) {
            this.addedToServiceDateTime = addedToServiceDateTime;
        }

        @Override
        public final Builder addedToServiceDateTime(String addedToServiceDateTime) {
            this.addedToServiceDateTime = addedToServiceDateTime;
            return this;
        }

        public final String getElapsedReplicationDuration() {
            return elapsedReplicationDuration;
        }

        public final void setElapsedReplicationDuration(String elapsedReplicationDuration) {
            this.elapsedReplicationDuration = elapsedReplicationDuration;
        }

        @Override
        public final Builder elapsedReplicationDuration(String elapsedReplicationDuration) {
            this.elapsedReplicationDuration = elapsedReplicationDuration;
            return this;
        }

        public final String getFirstByteDateTime() {
            return firstByteDateTime;
        }

        public final void setFirstByteDateTime(String firstByteDateTime) {
            this.firstByteDateTime = firstByteDateTime;
        }

        @Override
        public final Builder firstByteDateTime(String firstByteDateTime) {
            this.firstByteDateTime = firstByteDateTime;
            return this;
        }

        public final LifeCycleLastLaunch.Builder getLastLaunch() {
            return lastLaunch != null ? lastLaunch.toBuilder() : null;
        }

        public final void setLastLaunch(LifeCycleLastLaunch.BuilderImpl lastLaunch) {
            this.lastLaunch = lastLaunch != null ? lastLaunch.build() : null;
        }

        @Override
        public final Builder lastLaunch(LifeCycleLastLaunch lastLaunch) {
            this.lastLaunch = lastLaunch;
            return this;
        }

        public final String getLastSeenByServiceDateTime() {
            return lastSeenByServiceDateTime;
        }

        public final void setLastSeenByServiceDateTime(String lastSeenByServiceDateTime) {
            this.lastSeenByServiceDateTime = lastSeenByServiceDateTime;
        }

        @Override
        public final Builder lastSeenByServiceDateTime(String lastSeenByServiceDateTime) {
            this.lastSeenByServiceDateTime = lastSeenByServiceDateTime;
            return this;
        }

        @Override
        public LifeCycle build() {
            return new LifeCycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
