/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DBSubnetGroup;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse;

public class DescribeDBSubnetGroupsIterable
implements SdkIterable<DescribeDbSubnetGroupsResponse> {
    private final DocDbClient client;
    private final DescribeDbSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSubnetGroupsIterable(DocDbClient client, DescribeDbSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeDbSubnetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBSubnetGroup> dbSubnetGroups() {
        Function<DescribeDbSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSubnetGroups() != null) {
                return response.dbSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbSubnetGroupsResponse> {
        private DescribeDbSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbSubnetGroupsResponse nextPage(DescribeDbSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSubnetGroupsIterable.this.client.describeDBSubnetGroups(DescribeDBSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeDBSubnetGroupsIterable.this.client.describeDBSubnetGroups((DescribeDbSubnetGroupsRequest)((Object)DescribeDBSubnetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

