/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SnapshotType {
    AUTO("Auto"),
    MANUAL("Manual"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SnapshotType> VALUE_MAP;
    private final String value;

    private SnapshotType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SnapshotType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SnapshotType> knownValues() {
        EnumSet<SnapshotType> knownValues = EnumSet.allOf(SnapshotType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SnapshotType.class, SnapshotType::toString);
    }
}

