/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UpdateInfoEntry;

public class DescribeUpdateDirectoryIterable
implements SdkIterable<DescribeUpdateDirectoryResponse> {
    private final DirectoryClient client;
    private final DescribeUpdateDirectoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeUpdateDirectoryIterable(DirectoryClient client, DescribeUpdateDirectoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeUpdateDirectoryResponseFetcher();
    }

    public Iterator<DescribeUpdateDirectoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UpdateInfoEntry> updateActivities() {
        Function<DescribeUpdateDirectoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.updateActivities() != null) {
                return response.updateActivities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeUpdateDirectoryResponseFetcher
    implements SyncPageFetcher<DescribeUpdateDirectoryResponse> {
        private DescribeUpdateDirectoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUpdateDirectoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeUpdateDirectoryResponse nextPage(DescribeUpdateDirectoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeUpdateDirectoryIterable.this.client.describeUpdateDirectory(DescribeUpdateDirectoryIterable.this.firstRequest);
            }
            return DescribeUpdateDirectoryIterable.this.client.describeUpdateDirectory((DescribeUpdateDirectoryRequest)((Object)DescribeUpdateDirectoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

