/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.directconnect.DefaultDirectConnectBaseClientBuilder;
import software.amazon.awssdk.services.directconnect.DefaultDirectConnectClient;
import software.amazon.awssdk.services.directconnect.DirectConnectClient;
import software.amazon.awssdk.services.directconnect.DirectConnectClientBuilder;
import software.amazon.awssdk.services.directconnect.DirectConnectServiceClientConfiguration;
import software.amazon.awssdk.services.directconnect.endpoints.DirectConnectEndpointProvider;

@SdkInternalApi
final class DefaultDirectConnectClientBuilder
extends DefaultDirectConnectBaseClientBuilder<DirectConnectClientBuilder, DirectConnectClient>
implements DirectConnectClientBuilder {
    DefaultDirectConnectClientBuilder() {
    }

    @Override
    public DefaultDirectConnectClientBuilder endpointProvider(DirectConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DirectConnectClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDirectConnectClientBuilder.validateClientOptions(clientConfiguration);
        DirectConnectServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDirectConnectClient client = new DefaultDirectConnectClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DirectConnectServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DirectConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

