/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.internal.UserAgentUtils;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse;

public class ListTestGridProjectsPublisher
implements SdkPublisher<ListTestGridProjectsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListTestGridProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestGridProjectsPublisher(DeviceFarmAsyncClient client, ListTestGridProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestGridProjectsPublisher(DeviceFarmAsyncClient client, ListTestGridProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestGridProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestGridProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestGridProjectsResponseFetcher
    implements AsyncPageFetcher<ListTestGridProjectsResponse> {
        private ListTestGridProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestGridProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestGridProjectsResponse> nextPage(ListTestGridProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListTestGridProjectsPublisher.this.client.listTestGridProjects(ListTestGridProjectsPublisher.this.firstRequest);
            }
            return ListTestGridProjectsPublisher.this.client.listTestGridProjects((ListTestGridProjectsRequest)((Object)ListTestGridProjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

