/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.detective.DetectiveClient;
import software.amazon.awssdk.services.detective.internal.UserAgentUtils;
import software.amazon.awssdk.services.detective.model.ListGraphsRequest;
import software.amazon.awssdk.services.detective.model.ListGraphsResponse;

public class ListGraphsIterable
implements SdkIterable<ListGraphsResponse> {
    private final DetectiveClient client;
    private final ListGraphsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGraphsIterable(DetectiveClient client, ListGraphsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGraphsResponseFetcher();
    }

    public Iterator<ListGraphsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListGraphsResponseFetcher
    implements SyncPageFetcher<ListGraphsResponse> {
        private ListGraphsResponseFetcher() {
        }

        public boolean hasNextPage(ListGraphsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGraphsResponse nextPage(ListGraphsResponse previousPage) {
            if (previousPage == null) {
                return ListGraphsIterable.this.client.listGraphs(ListGraphsIterable.this.firstRequest);
            }
            return ListGraphsIterable.this.client.listGraphs((ListGraphsRequest)((Object)ListGraphsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

