/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.FilterValuesCopier;
import software.amazon.awssdk.services.datasync.model.LocationFilterName;
import software.amazon.awssdk.services.datasync.model.Operator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocationFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocationFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(LocationFilter.getter(LocationFilter::nameAsString)).setter(LocationFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(LocationFilter.getter(LocationFilter::values)).setter(LocationFilter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(LocationFilter.getter(LocationFilter::operatorAsString)).setter(LocationFilter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD, OPERATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> values;
    private final String operator;

    private LocationFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.operator = builder.operator;
    }

    public final LocationFilterName name() {
        return LocationFilterName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public final Operator operator() {
        return Operator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationFilter)) {
            return false;
        }
        LocationFilter other = (LocationFilter)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LocationFilter").add("Name", (Object)this.nameAsString()).add("Values", this.hasValues() ? this.values() : null).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocationFilter, T> g) {
        return obj -> g.apply((LocationFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationFilter model) {
            this.name(model.name);
            this.values(model.values);
            this.operator(model.operator);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(LocationFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getOperator() {
            return this.operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(Operator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public LocationFilter build() {
            return new LocationFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocationFilter> {
        public Builder name(String var1);

        public Builder name(LocationFilterName var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder operator(String var1);

        public Builder operator(Operator var1);
    }
}

