/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the AWS Lake Formation data permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeFormationDataPermissionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeFormationDataPermissionDetails.Builder, LakeFormationDataPermissionDetails> {
    private static final SdkField<LFTagPolicyDetails> LF_TAG_POLICY_FIELD = SdkField
            .<LFTagPolicyDetails> builder(MarshallingType.SDK_POJO).memberName("LFTagPolicy")
            .getter(getter(LakeFormationDataPermissionDetails::lfTagPolicy)).setter(setter(Builder::lfTagPolicy))
            .constructor(LFTagPolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTagPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LF_TAG_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final LFTagPolicyDetails lfTagPolicy;

    private LakeFormationDataPermissionDetails(BuilderImpl builder) {
        this.lfTagPolicy = builder.lfTagPolicy;
    }

    /**
     * <p>
     * Details about the LF-tag policy.
     * </p>
     * 
     * @return Details about the LF-tag policy.
     */
    public final LFTagPolicyDetails lfTagPolicy() {
        return lfTagPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lfTagPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationDataPermissionDetails)) {
            return false;
        }
        LakeFormationDataPermissionDetails other = (LakeFormationDataPermissionDetails) obj;
        return Objects.equals(lfTagPolicy(), other.lfTagPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LakeFormationDataPermissionDetails").add("LFTagPolicy", lfTagPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LFTagPolicy":
            return Optional.ofNullable(clazz.cast(lfTagPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationDataPermissionDetails, T> g) {
        return obj -> g.apply((LakeFormationDataPermissionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeFormationDataPermissionDetails> {
        /**
         * <p>
         * Details about the LF-tag policy.
         * </p>
         * 
         * @param lfTagPolicy
         *        Details about the LF-tag policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagPolicy(LFTagPolicyDetails lfTagPolicy);

        /**
         * <p>
         * Details about the LF-tag policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link LFTagPolicyDetails.Builder} avoiding the
         * need to create one manually via {@link LFTagPolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LFTagPolicyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #lfTagPolicy(LFTagPolicyDetails)}.
         * 
         * @param lfTagPolicy
         *        a consumer that will call methods on {@link LFTagPolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTagPolicy(LFTagPolicyDetails)
         */
        default Builder lfTagPolicy(Consumer<LFTagPolicyDetails.Builder> lfTagPolicy) {
            return lfTagPolicy(LFTagPolicyDetails.builder().applyMutation(lfTagPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LFTagPolicyDetails lfTagPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationDataPermissionDetails model) {
            lfTagPolicy(model.lfTagPolicy);
        }

        public final LFTagPolicyDetails.Builder getLfTagPolicy() {
            return lfTagPolicy != null ? lfTagPolicy.toBuilder() : null;
        }

        public final void setLfTagPolicy(LFTagPolicyDetails.BuilderImpl lfTagPolicy) {
            this.lfTagPolicy = lfTagPolicy != null ? lfTagPolicy.build() : null;
        }

        @Override
        public final Builder lfTagPolicy(LFTagPolicyDetails lfTagPolicy) {
            this.lfTagPolicy = lfTagPolicy;
            return this;
        }

        @Override
        public LakeFormationDataPermissionDetails build() {
            return new LakeFormationDataPermissionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
