/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error that occurred with the job request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobError implements SdkPojo, Serializable, ToCopyableBuilder<JobError.Builder, JobError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(JobError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<Details> DETAILS_FIELD = SdkField.<Details> builder(MarshallingType.SDK_POJO)
            .memberName("Details").getter(getter(JobError::details)).setter(setter(Builder::details))
            .constructor(Details::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final SdkField<String> LIMIT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LimitName").getter(getter(JobError::limitNameAsString)).setter(setter(Builder::limitName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitName").build()).build();

    private static final SdkField<Double> LIMIT_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LimitValue").getter(getter(JobError::limitValue)).setter(setter(Builder::limitValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitValue").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(JobError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(JobError::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(JobError::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, DETAILS_FIELD,
            LIMIT_NAME_FIELD, LIMIT_VALUE_FIELD, MESSAGE_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final Details details;

    private final String limitName;

    private final Double limitValue;

    private final String message;

    private final String resourceId;

    private final String resourceType;

    private JobError(BuilderImpl builder) {
        this.code = builder.code;
        this.details = builder.details;
        this.limitName = builder.limitName;
        this.limitValue = builder.limitValue;
        this.message = builder.message;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The code for the job error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link Code#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The code for the job error.
     * @see Code
     */
    public final Code code() {
        return Code.fromValue(code);
    }

    /**
     * <p>
     * The code for the job error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link Code#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The code for the job error.
     * @see Code
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * The details about the job error.
     * </p>
     * 
     * @return The details about the job error.
     */
    public final Details details() {
        return details;
    }

    /**
     * <p>
     * The name of the limit that was reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limitName} will
     * return {@link JobErrorLimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #limitNameAsString}.
     * </p>
     * 
     * @return The name of the limit that was reached.
     * @see JobErrorLimitName
     */
    public final JobErrorLimitName limitName() {
        return JobErrorLimitName.fromValue(limitName);
    }

    /**
     * <p>
     * The name of the limit that was reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #limitName} will
     * return {@link JobErrorLimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #limitNameAsString}.
     * </p>
     * 
     * @return The name of the limit that was reached.
     * @see JobErrorLimitName
     */
    public final String limitNameAsString() {
        return limitName;
    }

    /**
     * <p>
     * The value of the exceeded limit.
     * </p>
     * 
     * @return The value of the exceeded limit.
     */
    public final Double limitValue() {
        return limitValue;
    }

    /**
     * <p>
     * The message related to the job error.
     * </p>
     * 
     * @return The message related to the job error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The unique identifier for the resource related to the error.
     * </p>
     * 
     * @return The unique identifier for the resource related to the error.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource related to the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link JobErrorResourceTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource related to the error.
     * @see JobErrorResourceTypes
     */
    public final JobErrorResourceTypes resourceType() {
        return JobErrorResourceTypes.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource related to the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link JobErrorResourceTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource related to the error.
     * @see JobErrorResourceTypes
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(limitNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limitValue());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobError)) {
            return false;
        }
        JobError other = (JobError) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(details(), other.details())
                && Objects.equals(limitNameAsString(), other.limitNameAsString())
                && Objects.equals(limitValue(), other.limitValue()) && Objects.equals(message(), other.message())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobError").add("Code", codeAsString()).add("Details", details())
                .add("LimitName", limitNameAsString()).add("LimitValue", limitValue()).add("Message", message())
                .add("ResourceId", resourceId()).add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "LimitName":
            return Optional.ofNullable(clazz.cast(limitNameAsString()));
        case "LimitValue":
            return Optional.ofNullable(clazz.cast(limitValue()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobError, T> g) {
        return obj -> g.apply((JobError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobError> {
        /**
         * <p>
         * The code for the job error.
         * </p>
         * 
         * @param code
         *        The code for the job error.
         * @see Code
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Code
         */
        Builder code(String code);

        /**
         * <p>
         * The code for the job error.
         * </p>
         * 
         * @param code
         *        The code for the job error.
         * @see Code
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Code
         */
        Builder code(Code code);

        /**
         * <p>
         * The details about the job error.
         * </p>
         * 
         * @param details
         *        The details about the job error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Details details);

        /**
         * <p>
         * The details about the job error.
         * </p>
         * This is a convenience method that creates an instance of the {@link Details.Builder} avoiding the need to
         * create one manually via {@link Details#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Details.Builder#build()} is called immediately and its result is
         * passed to {@link #details(Details)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link Details.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(Details)
         */
        default Builder details(Consumer<Details.Builder> details) {
            return details(Details.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The name of the limit that was reached.
         * </p>
         * 
         * @param limitName
         *        The name of the limit that was reached.
         * @see JobErrorLimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobErrorLimitName
         */
        Builder limitName(String limitName);

        /**
         * <p>
         * The name of the limit that was reached.
         * </p>
         * 
         * @param limitName
         *        The name of the limit that was reached.
         * @see JobErrorLimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobErrorLimitName
         */
        Builder limitName(JobErrorLimitName limitName);

        /**
         * <p>
         * The value of the exceeded limit.
         * </p>
         * 
         * @param limitValue
         *        The value of the exceeded limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitValue(Double limitValue);

        /**
         * <p>
         * The message related to the job error.
         * </p>
         * 
         * @param message
         *        The message related to the job error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The unique identifier for the resource related to the error.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for the resource related to the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource related to the error.
         * </p>
         * 
         * @param resourceType
         *        The type of resource related to the error.
         * @see JobErrorResourceTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobErrorResourceTypes
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource related to the error.
         * </p>
         * 
         * @param resourceType
         *        The type of resource related to the error.
         * @see JobErrorResourceTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobErrorResourceTypes
         */
        Builder resourceType(JobErrorResourceTypes resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private Details details;

        private String limitName;

        private Double limitValue;

        private String message;

        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobError model) {
            code(model.code);
            details(model.details);
            limitName(model.limitName);
            limitValue(model.limitValue);
            message(model.message);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(Code code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final Details.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(Details.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(Details details) {
            this.details = details;
            return this;
        }

        public final String getLimitName() {
            return limitName;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        @Override
        public final Builder limitName(JobErrorLimitName limitName) {
            this.limitName(limitName == null ? null : limitName.toString());
            return this;
        }

        public final Double getLimitValue() {
            return limitValue;
        }

        public final void setLimitValue(Double limitValue) {
            this.limitValue = limitValue;
        }

        @Override
        public final Builder limitValue(Double limitValue) {
            this.limitValue = limitValue;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(JobErrorResourceTypes resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public JobError build() {
            return new JobError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
