/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRevisionRequest
extends DataExchangeRequest
implements ToCopyableBuilder<Builder, UpdateRevisionRequest> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(UpdateRevisionRequest.getter(UpdateRevisionRequest::comment)).setter(UpdateRevisionRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(UpdateRevisionRequest.getter(UpdateRevisionRequest::dataSetId)).setter(UpdateRevisionRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final SdkField<Boolean> FINALIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Finalized").getter(UpdateRevisionRequest.getter(UpdateRevisionRequest::finalized)).setter(UpdateRevisionRequest.setter(Builder::finalized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Finalized").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(UpdateRevisionRequest.getter(UpdateRevisionRequest::revisionId)).setter(UpdateRevisionRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, DATA_SET_ID_FIELD, FINALIZED_FIELD, REVISION_ID_FIELD));
    private final String comment;
    private final String dataSetId;
    private final Boolean finalized;
    private final String revisionId;

    private UpdateRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.comment = builder.comment;
        this.dataSetId = builder.dataSetId;
        this.finalized = builder.finalized;
        this.revisionId = builder.revisionId;
    }

    public final String comment() {
        return this.comment;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final Boolean finalized() {
        return this.finalized;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalized());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRevisionRequest)) {
            return false;
        }
        UpdateRevisionRequest other = (UpdateRevisionRequest)((Object)obj);
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.finalized(), other.finalized()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRevisionRequest").add("Comment", (Object)this.comment()).add("DataSetId", (Object)this.dataSetId()).add("Finalized", (Object)this.finalized()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Finalized": {
                return Optional.ofNullable(clazz.cast(this.finalized()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRevisionRequest, T> g) {
        return obj -> g.apply((UpdateRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeRequest.BuilderImpl
    implements Builder {
        private String comment;
        private String dataSetId;
        private Boolean finalized;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRevisionRequest model) {
            super(model);
            this.comment(model.comment);
            this.dataSetId(model.dataSetId);
            this.finalized(model.finalized);
            this.revisionId(model.revisionId);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final Boolean getFinalized() {
            return this.finalized;
        }

        public final void setFinalized(Boolean finalized) {
            this.finalized = finalized;
        }

        @Override
        public final Builder finalized(Boolean finalized) {
            this.finalized = finalized;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRevisionRequest build() {
            return new UpdateRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRevisionRequest> {
        public Builder comment(String var1);

        public Builder dataSetId(String var1);

        public Builder finalized(Boolean var1);

        public Builder revisionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

