/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityDetectorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityDetectorConfiguration.Builder, EntityDetectorConfiguration> {
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EntityTypes")
            .getter(getter(EntityDetectorConfiguration::entityTypes))
            .setter(setter(Builder::entityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AllowedStatistics>> ALLOWED_STATISTICS_FIELD = SdkField
            .<List<AllowedStatistics>> builder(MarshallingType.LIST)
            .memberName("AllowedStatistics")
            .getter(getter(EntityDetectorConfiguration::allowedStatistics))
            .setter(setter(Builder::allowedStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedStatistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AllowedStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(AllowedStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD,
            ALLOWED_STATISTICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> entityTypes;

    private final List<AllowedStatistics> allowedStatistics;

    private EntityDetectorConfiguration(BuilderImpl builder) {
        this.entityTypes = builder.entityTypes;
        this.allowedStatistics = builder.allowedStatistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityTypes() {
        return entityTypes != null && !(entityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Entity types to detect. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * USA_SSN
     * </p>
     * </li>
     * <li>
     * <p>
     * EMAIL
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_ITIN
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_PASSPORT_NUMBER
     * </p>
     * </li>
     * <li>
     * <p>
     * PHONE_NUMBER
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_DRIVING_LICENSE
     * </p>
     * </li>
     * <li>
     * <p>
     * BANK_ACCOUNT
     * </p>
     * </li>
     * <li>
     * <p>
     * CREDIT_CARD
     * </p>
     * </li>
     * <li>
     * <p>
     * IP_ADDRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * MAC_ADDRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_DEA_NUMBER
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_HCPCS_CODE
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_NATIONAL_PROVIDER_IDENTIFIER
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_NATIONAL_DRUG_CODE
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_HEALTH_INSURANCE_CLAIM_NUMBER
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_MEDICARE_BENEFICIARY_IDENTIFIER
     * </p>
     * </li>
     * <li>
     * <p>
     * USA_CPT_CODE
     * </p>
     * </li>
     * <li>
     * <p>
     * PERSON_NAME
     * </p>
     * </li>
     * <li>
     * <p>
     * DATE
     * </p>
     * </li>
     * </ul>
     * <p>
     * The Entity type group USA_ALL is also supported, and includes all of the above entity types except PERSON_NAME
     * and DATE.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityTypes} method.
     * </p>
     * 
     * @return Entity types to detect. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         USA_SSN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_ITIN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_PASSPORT_NUMBER
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PHONE_NUMBER
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_DRIVING_LICENSE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BANK_ACCOUNT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREDIT_CARD
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IP_ADDRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MAC_ADDRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_DEA_NUMBER
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_HCPCS_CODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_NATIONAL_PROVIDER_IDENTIFIER
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_NATIONAL_DRUG_CODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_HEALTH_INSURANCE_CLAIM_NUMBER
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_MEDICARE_BENEFICIARY_IDENTIFIER
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USA_CPT_CODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PERSON_NAME
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATE
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The Entity type group USA_ALL is also supported, and includes all of the above entity types except
     *         PERSON_NAME and DATE.
     */
    public final List<String> entityTypes() {
        return entityTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedStatistics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedStatistics() {
        return allowedStatistics != null && !(allowedStatistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration of statistics that are allowed to be run on columns that contain detected entities. When undefined,
     * no statistics will be computed on columns that contain detected entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedStatistics} method.
     * </p>
     * 
     * @return Configuration of statistics that are allowed to be run on columns that contain detected entities. When
     *         undefined, no statistics will be computed on columns that contain detected entities.
     */
    public final List<AllowedStatistics> allowedStatistics() {
        return allowedStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityTypes() ? entityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedStatistics() ? allowedStatistics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDetectorConfiguration)) {
            return false;
        }
        EntityDetectorConfiguration other = (EntityDetectorConfiguration) obj;
        return hasEntityTypes() == other.hasEntityTypes() && Objects.equals(entityTypes(), other.entityTypes())
                && hasAllowedStatistics() == other.hasAllowedStatistics()
                && Objects.equals(allowedStatistics(), other.allowedStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityDetectorConfiguration").add("EntityTypes", hasEntityTypes() ? entityTypes() : null)
                .add("AllowedStatistics", hasAllowedStatistics() ? allowedStatistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityTypes":
            return Optional.ofNullable(clazz.cast(entityTypes()));
        case "AllowedStatistics":
            return Optional.ofNullable(clazz.cast(allowedStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityDetectorConfiguration, T> g) {
        return obj -> g.apply((EntityDetectorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityDetectorConfiguration> {
        /**
         * <p>
         * Entity types to detect. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * USA_SSN
         * </p>
         * </li>
         * <li>
         * <p>
         * EMAIL
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_ITIN
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_PASSPORT_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * PHONE_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_DRIVING_LICENSE
         * </p>
         * </li>
         * <li>
         * <p>
         * BANK_ACCOUNT
         * </p>
         * </li>
         * <li>
         * <p>
         * CREDIT_CARD
         * </p>
         * </li>
         * <li>
         * <p>
         * IP_ADDRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * MAC_ADDRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_DEA_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_HCPCS_CODE
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_NATIONAL_PROVIDER_IDENTIFIER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_NATIONAL_DRUG_CODE
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_HEALTH_INSURANCE_CLAIM_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_MEDICARE_BENEFICIARY_IDENTIFIER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_CPT_CODE
         * </p>
         * </li>
         * <li>
         * <p>
         * PERSON_NAME
         * </p>
         * </li>
         * <li>
         * <p>
         * DATE
         * </p>
         * </li>
         * </ul>
         * <p>
         * The Entity type group USA_ALL is also supported, and includes all of the above entity types except
         * PERSON_NAME and DATE.
         * </p>
         * 
         * @param entityTypes
         *        Entity types to detect. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        USA_SSN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMAIL
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_ITIN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_PASSPORT_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PHONE_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_DRIVING_LICENSE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BANK_ACCOUNT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREDIT_CARD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IP_ADDRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MAC_ADDRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_DEA_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_HCPCS_CODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_NATIONAL_PROVIDER_IDENTIFIER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_NATIONAL_DRUG_CODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_HEALTH_INSURANCE_CLAIM_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_MEDICARE_BENEFICIARY_IDENTIFIER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_CPT_CODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PERSON_NAME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATE
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The Entity type group USA_ALL is also supported, and includes all of the above entity types except
         *        PERSON_NAME and DATE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(Collection<String> entityTypes);

        /**
         * <p>
         * Entity types to detect. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * USA_SSN
         * </p>
         * </li>
         * <li>
         * <p>
         * EMAIL
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_ITIN
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_PASSPORT_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * PHONE_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_DRIVING_LICENSE
         * </p>
         * </li>
         * <li>
         * <p>
         * BANK_ACCOUNT
         * </p>
         * </li>
         * <li>
         * <p>
         * CREDIT_CARD
         * </p>
         * </li>
         * <li>
         * <p>
         * IP_ADDRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * MAC_ADDRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_DEA_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_HCPCS_CODE
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_NATIONAL_PROVIDER_IDENTIFIER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_NATIONAL_DRUG_CODE
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_HEALTH_INSURANCE_CLAIM_NUMBER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_MEDICARE_BENEFICIARY_IDENTIFIER
         * </p>
         * </li>
         * <li>
         * <p>
         * USA_CPT_CODE
         * </p>
         * </li>
         * <li>
         * <p>
         * PERSON_NAME
         * </p>
         * </li>
         * <li>
         * <p>
         * DATE
         * </p>
         * </li>
         * </ul>
         * <p>
         * The Entity type group USA_ALL is also supported, and includes all of the above entity types except
         * PERSON_NAME and DATE.
         * </p>
         * 
         * @param entityTypes
         *        Entity types to detect. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        USA_SSN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMAIL
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_ITIN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_PASSPORT_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PHONE_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_DRIVING_LICENSE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BANK_ACCOUNT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREDIT_CARD
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IP_ADDRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MAC_ADDRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_DEA_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_HCPCS_CODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_NATIONAL_PROVIDER_IDENTIFIER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_NATIONAL_DRUG_CODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_HEALTH_INSURANCE_CLAIM_NUMBER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_MEDICARE_BENEFICIARY_IDENTIFIER
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USA_CPT_CODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PERSON_NAME
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATE
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The Entity type group USA_ALL is also supported, and includes all of the above entity types except
         *        PERSON_NAME and DATE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(String... entityTypes);

        /**
         * <p>
         * Configuration of statistics that are allowed to be run on columns that contain detected entities. When
         * undefined, no statistics will be computed on columns that contain detected entities.
         * </p>
         * 
         * @param allowedStatistics
         *        Configuration of statistics that are allowed to be run on columns that contain detected entities. When
         *        undefined, no statistics will be computed on columns that contain detected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStatistics(Collection<AllowedStatistics> allowedStatistics);

        /**
         * <p>
         * Configuration of statistics that are allowed to be run on columns that contain detected entities. When
         * undefined, no statistics will be computed on columns that contain detected entities.
         * </p>
         * 
         * @param allowedStatistics
         *        Configuration of statistics that are allowed to be run on columns that contain detected entities. When
         *        undefined, no statistics will be computed on columns that contain detected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedStatistics(AllowedStatistics... allowedStatistics);

        /**
         * <p>
         * Configuration of statistics that are allowed to be run on columns that contain detected entities. When
         * undefined, no statistics will be computed on columns that contain detected entities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databrew.model.AllowedStatistics.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.databrew.model.AllowedStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databrew.model.AllowedStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #allowedStatistics(List<AllowedStatistics>)}.
         * 
         * @param allowedStatistics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databrew.model.AllowedStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedStatistics(java.util.Collection<AllowedStatistics>)
         */
        Builder allowedStatistics(Consumer<AllowedStatistics.Builder>... allowedStatistics);
    }

    static final class BuilderImpl implements Builder {
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private List<AllowedStatistics> allowedStatistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDetectorConfiguration model) {
            entityTypes(model.entityTypes);
            allowedStatistics(model.allowedStatistics);
        }

        public final Collection<String> getEntityTypes() {
            if (entityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return entityTypes;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = EntityTypeListCopier.copy(entityTypes);
        }

        @Override
        public final Builder entityTypes(Collection<String> entityTypes) {
            this.entityTypes = EntityTypeListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(String... entityTypes) {
            entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final List<AllowedStatistics.Builder> getAllowedStatistics() {
            List<AllowedStatistics.Builder> result = AllowedStatisticListCopier.copyToBuilder(this.allowedStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedStatistics(Collection<AllowedStatistics.BuilderImpl> allowedStatistics) {
            this.allowedStatistics = AllowedStatisticListCopier.copyFromBuilder(allowedStatistics);
        }

        @Override
        public final Builder allowedStatistics(Collection<AllowedStatistics> allowedStatistics) {
            this.allowedStatistics = AllowedStatisticListCopier.copy(allowedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStatistics(AllowedStatistics... allowedStatistics) {
            allowedStatistics(Arrays.asList(allowedStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStatistics(Consumer<AllowedStatistics.Builder>... allowedStatistics) {
            allowedStatistics(Stream.of(allowedStatistics).map(c -> AllowedStatistics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EntityDetectorConfiguration build() {
            return new EntityDetectorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
