/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.databrew.DataBrewAsyncClient;
import software.amazon.awssdk.services.databrew.DataBrewAsyncClientBuilder;
import software.amazon.awssdk.services.databrew.DataBrewServiceClientConfiguration;
import software.amazon.awssdk.services.databrew.DefaultDataBrewAsyncClient;
import software.amazon.awssdk.services.databrew.DefaultDataBrewBaseClientBuilder;
import software.amazon.awssdk.services.databrew.endpoints.DataBrewEndpointProvider;

@SdkInternalApi
final class DefaultDataBrewAsyncClientBuilder
extends DefaultDataBrewBaseClientBuilder<DataBrewAsyncClientBuilder, DataBrewAsyncClient>
implements DataBrewAsyncClientBuilder {
    DefaultDataBrewAsyncClientBuilder() {
    }

    @Override
    public DefaultDataBrewAsyncClientBuilder endpointProvider(DataBrewEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataBrewAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDataBrewAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DataBrewServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDataBrewAsyncClient client = new DefaultDataBrewAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DataBrewServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DataBrewServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

