/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationSubnetGroupRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyReplicationSubnetGroupRequest.Builder, ModifyReplicationSubnetGroupRequest> {
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSubnetGroupIdentifier")
            .getter(getter(ModifyReplicationSubnetGroupRequest::replicationSubnetGroupIdentifier))
            .setter(setter(Builder::replicationSubnetGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSubnetGroupDescription")
            .getter(getter(ModifyReplicationSubnetGroupRequest::replicationSubnetGroupDescription))
            .setter(setter(Builder::replicationSubnetGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupDescription")
                    .build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(ModifyReplicationSubnetGroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD, REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD, SUBNET_IDS_FIELD));

    private final String replicationSubnetGroupIdentifier;

    private final String replicationSubnetGroupDescription;

    private final List<String> subnetIds;

    private ModifyReplicationSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.replicationSubnetGroupDescription = builder.replicationSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
    }

    /**
     * <p>
     * The name of the replication instance subnet group.
     * </p>
     * 
     * @return The name of the replication instance subnet group.
     */
    public final String replicationSubnetGroupIdentifier() {
        return replicationSubnetGroupIdentifier;
    }

    /**
     * <p>
     * A description for the replication instance subnet group.
     * </p>
     * 
     * @return A description for the replication instance subnet group.
     */
    public final String replicationSubnetGroupDescription() {
        return replicationSubnetGroupDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of subnet IDs.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationSubnetGroupRequest)) {
            return false;
        }
        ModifyReplicationSubnetGroupRequest other = (ModifyReplicationSubnetGroupRequest) obj;
        return Objects.equals(replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier())
                && Objects.equals(replicationSubnetGroupDescription(), other.replicationSubnetGroupDescription())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyReplicationSubnetGroupRequest")
                .add("ReplicationSubnetGroupIdentifier", replicationSubnetGroupIdentifier())
                .add("ReplicationSubnetGroupDescription", replicationSubnetGroupDescription())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationSubnetGroupIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupIdentifier()));
        case "ReplicationSubnetGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupDescription()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationSubnetGroupRequest, T> g) {
        return obj -> g.apply((ModifyReplicationSubnetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyReplicationSubnetGroupRequest> {
        /**
         * <p>
         * The name of the replication instance subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupIdentifier
         *        The name of the replication instance subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier);

        /**
         * <p>
         * A description for the replication instance subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupDescription
         *        A description for the replication instance subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription);

        /**
         * <p>
         * A list of subnet IDs.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationSubnetGroupIdentifier;

        private String replicationSubnetGroupDescription;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationSubnetGroupRequest model) {
            super(model);
            replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            replicationSubnetGroupDescription(model.replicationSubnetGroupDescription);
            subnetIds(model.subnetIds);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return replicationSubnetGroupIdentifier;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final String getReplicationSubnetGroupDescription() {
            return replicationSubnetGroupDescription;
        }

        public final void setReplicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
        }

        @Override
        public final Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationSubnetGroupRequest build() {
            return new ModifyReplicationSubnetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
