/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.FlowDefinition;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, PutIntegrationRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(PutIntegrationRequest.getter(PutIntegrationRequest::domainName)).setter(PutIntegrationRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uri").getter(PutIntegrationRequest.getter(PutIntegrationRequest::uri)).setter(PutIntegrationRequest.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(PutIntegrationRequest.getter(PutIntegrationRequest::objectTypeName)).setter(PutIntegrationRequest.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(PutIntegrationRequest.getter(PutIntegrationRequest::tags)).setter(PutIntegrationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<FlowDefinition> FLOW_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowDefinition").getter(PutIntegrationRequest.getter(PutIntegrationRequest::flowDefinition)).setter(PutIntegrationRequest.setter(Builder::flowDefinition)).constructor(FlowDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, URI_FIELD, OBJECT_TYPE_NAME_FIELD, TAGS_FIELD, FLOW_DEFINITION_FIELD));
    private final String domainName;
    private final String uri;
    private final String objectTypeName;
    private final Map<String, String> tags;
    private final FlowDefinition flowDefinition;

    private PutIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.uri = builder.uri;
        this.objectTypeName = builder.objectTypeName;
        this.tags = builder.tags;
        this.flowDefinition = builder.flowDefinition;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String uri() {
        return this.uri;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final FlowDefinition flowDefinition() {
        return this.flowDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationRequest)) {
            return false;
        }
        PutIntegrationRequest other = (PutIntegrationRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.flowDefinition(), other.flowDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"PutIntegrationRequest").add("DomainName", (Object)this.domainName()).add("Uri", (Object)this.uri()).add("ObjectTypeName", (Object)this.objectTypeName()).add("Tags", this.hasTags() ? this.tags() : null).add("FlowDefinition", (Object)this.flowDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FlowDefinition": {
                return Optional.ofNullable(clazz.cast(this.flowDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationRequest, T> g) {
        return obj -> g.apply((PutIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String uri;
        private String objectTypeName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private FlowDefinition flowDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.uri(model.uri);
            this.objectTypeName(model.objectTypeName);
            this.tags(model.tags);
            this.flowDefinition(model.flowDefinition);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        @Transient
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        @Transient
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final FlowDefinition.Builder getFlowDefinition() {
            return this.flowDefinition != null ? this.flowDefinition.toBuilder() : null;
        }

        public final void setFlowDefinition(FlowDefinition.BuilderImpl flowDefinition) {
            this.flowDefinition = flowDefinition != null ? flowDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder flowDefinition(FlowDefinition flowDefinition) {
            this.flowDefinition = flowDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntegrationRequest build() {
            return new PutIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntegrationRequest> {
        public Builder domainName(String var1);

        public Builder uri(String var1);

        public Builder objectTypeName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder flowDefinition(FlowDefinition var1);

        default public Builder flowDefinition(Consumer<FlowDefinition.Builder> flowDefinition) {
            return this.flowDefinition((FlowDefinition)((FlowDefinition.Builder)FlowDefinition.builder().applyMutation(flowDefinition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

