/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.nio.ByteBuffer;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;

class HttpStreamResponseHandlerNativeAdapter {
    private HttpStreamResponseHandler responseHandler;

    HttpStreamResponseHandlerNativeAdapter(HttpStreamResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    void onResponseHeaders(HttpStream stream, int responseStatusCode, int blockType, ByteBuffer headersBlob) {
        HttpHeader[] headersArray = HttpHeader.loadHeadersFromMarshalledHeadersBlob(headersBlob);
        this.responseHandler.onResponseHeaders(stream, responseStatusCode, blockType, headersArray);
    }

    void onResponseHeadersDone(HttpStream stream, int blockType) {
        this.responseHandler.onResponseHeadersDone(stream, blockType);
    }

    int onResponseBody(HttpStream stream, ByteBuffer bodyBytesIn) {
        byte[] body = new byte[bodyBytesIn.limit()];
        bodyBytesIn.get(body);
        return this.responseHandler.onResponseBody(stream, body);
    }

    void onResponseComplete(HttpStream stream, int errorCode) {
        this.responseHandler.onResponseComplete(stream, errorCode);
    }
}

