/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.RequestCharged;
import com.amazonaws.s3.model.ServerSideEncryption;
import java.util.Objects;

public class PutObjectOutput {
    String expiration;
    String eTag;
    ServerSideEncryption serverSideEncryption;
    String versionId;
    String sSECustomerAlgorithm;
    String sSECustomerKeyMD5;
    String sSEKMSKeyId;
    String sSEKMSEncryptionContext;
    Boolean bucketKeyEnabled;
    RequestCharged requestCharged;

    PutObjectOutput() {
        this.expiration = "";
        this.eTag = "";
        this.serverSideEncryption = null;
        this.versionId = "";
        this.sSECustomerAlgorithm = "";
        this.sSECustomerKeyMD5 = "";
        this.sSEKMSKeyId = "";
        this.sSEKMSEncryptionContext = "";
        this.bucketKeyEnabled = null;
        this.requestCharged = null;
    }

    protected PutObjectOutput(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.eTag = builder.eTag;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.versionId = builder.versionId;
        this.sSECustomerAlgorithm = builder.sSECustomerAlgorithm;
        this.sSECustomerKeyMD5 = builder.sSECustomerKeyMD5;
        this.sSEKMSKeyId = builder.sSEKMSKeyId;
        this.sSEKMSEncryptionContext = builder.sSEKMSEncryptionContext;
        this.bucketKeyEnabled = builder.bucketKeyEnabled;
        this.requestCharged = builder.requestCharged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutObjectOutput.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutObjectOutput;
    }

    public String expiration() {
        return this.expiration;
    }

    public String eTag() {
        return this.eTag;
    }

    public ServerSideEncryption serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public String versionId() {
        return this.versionId;
    }

    public String sSECustomerAlgorithm() {
        return this.sSECustomerAlgorithm;
    }

    public String sSECustomerKeyMD5() {
        return this.sSECustomerKeyMD5;
    }

    public String sSEKMSKeyId() {
        return this.sSEKMSKeyId;
    }

    public String sSEKMSEncryptionContext() {
        return this.sSEKMSEncryptionContext;
    }

    public Boolean bucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    public RequestCharged requestCharged() {
        return this.requestCharged;
    }

    protected static class BuilderImpl
    implements Builder {
        String expiration;
        String eTag;
        ServerSideEncryption serverSideEncryption;
        String versionId;
        String sSECustomerAlgorithm;
        String sSECustomerKeyMD5;
        String sSEKMSKeyId;
        String sSEKMSEncryptionContext;
        Boolean bucketKeyEnabled;
        RequestCharged requestCharged;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutObjectOutput model) {
            this.expiration(model.expiration);
            this.eTag(model.eTag);
            this.serverSideEncryption(model.serverSideEncryption);
            this.versionId(model.versionId);
            this.sSECustomerAlgorithm(model.sSECustomerAlgorithm);
            this.sSECustomerKeyMD5(model.sSECustomerKeyMD5);
            this.sSEKMSKeyId(model.sSEKMSKeyId);
            this.sSEKMSEncryptionContext(model.sSEKMSEncryptionContext);
            this.bucketKeyEnabled(model.bucketKeyEnabled);
            this.requestCharged(model.requestCharged);
        }

        @Override
        public PutObjectOutput build() {
            return new PutObjectOutput(this);
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public final Builder sSECustomerAlgorithm(String sSECustomerAlgorithm) {
            this.sSECustomerAlgorithm = sSECustomerAlgorithm;
            return this;
        }

        @Override
        public final Builder sSECustomerKeyMD5(String sSECustomerKeyMD5) {
            this.sSECustomerKeyMD5 = sSECustomerKeyMD5;
            return this;
        }

        @Override
        public final Builder sSEKMSKeyId(String sSEKMSKeyId) {
            this.sSEKMSKeyId = sSEKMSKeyId;
            return this;
        }

        @Override
        public final Builder sSEKMSEncryptionContext(String sSEKMSEncryptionContext) {
            this.sSEKMSEncryptionContext = sSEKMSEncryptionContext;
            return this;
        }

        @Override
        public final Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = bucketKeyEnabled;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String expiration() {
            return this.expiration;
        }

        public String eTag() {
            return this.eTag;
        }

        public ServerSideEncryption serverSideEncryption() {
            return this.serverSideEncryption;
        }

        public String versionId() {
            return this.versionId;
        }

        public String sSECustomerAlgorithm() {
            return this.sSECustomerAlgorithm;
        }

        public String sSECustomerKeyMD5() {
            return this.sSECustomerKeyMD5;
        }

        public String sSEKMSKeyId() {
            return this.sSEKMSKeyId;
        }

        public String sSEKMSEncryptionContext() {
            return this.sSEKMSEncryptionContext;
        }

        public Boolean bucketKeyEnabled() {
            return this.bucketKeyEnabled;
        }

        public RequestCharged requestCharged() {
            return this.requestCharged;
        }
    }

    public static interface Builder {
        public Builder expiration(String var1);

        public Builder eTag(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder versionId(String var1);

        public Builder sSECustomerAlgorithm(String var1);

        public Builder sSECustomerKeyMD5(String var1);

        public Builder sSEKMSKeyId(String var1);

        public Builder sSEKMSEncryptionContext(String var1);

        public Builder bucketKeyEnabled(Boolean var1);

        public Builder requestCharged(RequestCharged var1);

        public PutObjectOutput build();
    }
}

