/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.BucketLoggingStatus;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class PutBucketLoggingRequest {
    String bucket;
    BucketLoggingStatus bucketLoggingStatus;
    String contentMD5;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    PutBucketLoggingRequest() {
        this.bucket = "";
        this.bucketLoggingStatus = null;
        this.contentMD5 = "";
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected PutBucketLoggingRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.bucketLoggingStatus = builder.bucketLoggingStatus;
        this.contentMD5 = builder.contentMD5;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutBucketLoggingRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutBucketLoggingRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public BucketLoggingStatus bucketLoggingStatus() {
        return this.bucketLoggingStatus;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        BucketLoggingStatus bucketLoggingStatus;
        String contentMD5;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutBucketLoggingRequest model) {
            this.bucket(model.bucket);
            this.bucketLoggingStatus(model.bucketLoggingStatus);
            this.contentMD5(model.contentMD5);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public PutBucketLoggingRequest build() {
            return new PutBucketLoggingRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder bucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public BucketLoggingStatus bucketLoggingStatus() {
            return this.bucketLoggingStatus;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder bucketLoggingStatus(BucketLoggingStatus var1);

        public Builder contentMD5(String var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public PutBucketLoggingRequest build();
    }
}

