/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FindingReasonCode {
    CPU_OVER_PROVISIONED("CPU_OVER_PROVISIONED"),
    CPU_UNDER_PROVISIONED("CPU_UNDER_PROVISIONED"),
    MEMORY_OVER_PROVISIONED("MEMORY_OVER_PROVISIONED"),
    MEMORY_UNDER_PROVISIONED("MEMORY_UNDER_PROVISIONED"),
    EBS_THROUGHPUT_OVER_PROVISIONED("EBS_THROUGHPUT_OVER_PROVISIONED"),
    EBS_THROUGHPUT_UNDER_PROVISIONED("EBS_THROUGHPUT_UNDER_PROVISIONED"),
    EBS_IOPS_OVER_PROVISIONED("EBS_IOPS_OVER_PROVISIONED"),
    EBS_IOPS_UNDER_PROVISIONED("EBS_IOPS_UNDER_PROVISIONED"),
    NETWORK_BANDWIDTH_OVER_PROVISIONED("NETWORK_BANDWIDTH_OVER_PROVISIONED"),
    NETWORK_BANDWIDTH_UNDER_PROVISIONED("NETWORK_BANDWIDTH_UNDER_PROVISIONED"),
    NETWORK_PPS_OVER_PROVISIONED("NETWORK_PPS_OVER_PROVISIONED"),
    NETWORK_PPS_UNDER_PROVISIONED("NETWORK_PPS_UNDER_PROVISIONED"),
    DISK_IOPS_OVER_PROVISIONED("DISK_IOPS_OVER_PROVISIONED"),
    DISK_IOPS_UNDER_PROVISIONED("DISK_IOPS_UNDER_PROVISIONED"),
    DISK_THROUGHPUT_OVER_PROVISIONED("DISK_THROUGHPUT_OVER_PROVISIONED"),
    DISK_THROUGHPUT_UNDER_PROVISIONED("DISK_THROUGHPUT_UNDER_PROVISIONED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FindingReasonCode> VALUE_MAP;
    private final String value;

    private FindingReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingReasonCode> knownValues() {
        EnumSet<FindingReasonCode> knownValues = EnumSet.allOf(FindingReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FindingReasonCode.class, FindingReasonCode::toString);
    }
}

