/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClientBuilder;
import software.amazon.awssdk.services.costexplorer.CostExplorerServiceClientConfiguration;
import software.amazon.awssdk.services.costexplorer.DefaultCostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.DefaultCostExplorerBaseClientBuilder;
import software.amazon.awssdk.services.costexplorer.endpoints.CostExplorerEndpointProvider;

@SdkInternalApi
final class DefaultCostExplorerAsyncClientBuilder
extends DefaultCostExplorerBaseClientBuilder<CostExplorerAsyncClientBuilder, CostExplorerAsyncClient>
implements CostExplorerAsyncClientBuilder {
    DefaultCostExplorerAsyncClientBuilder() {
    }

    @Override
    public DefaultCostExplorerAsyncClientBuilder endpointProvider(CostExplorerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CostExplorerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCostExplorerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CostExplorerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCostExplorerAsyncClient client = new DefaultCostExplorerAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CostExplorerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CostExplorerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

