/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAnomaliesRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetAnomaliesRequest.Builder, GetAnomaliesRequest> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(GetAnomaliesRequest::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<AnomalyDateInterval> DATE_INTERVAL_FIELD = SdkField
            .<AnomalyDateInterval> builder(MarshallingType.SDK_POJO).memberName("DateInterval")
            .getter(getter(GetAnomaliesRequest::dateInterval)).setter(setter(Builder::dateInterval))
            .constructor(AnomalyDateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateInterval").build()).build();

    private static final SdkField<String> FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Feedback").getter(getter(GetAnomaliesRequest::feedbackAsString)).setter(setter(Builder::feedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build()).build();

    private static final SdkField<TotalImpactFilter> TOTAL_IMPACT_FIELD = SdkField
            .<TotalImpactFilter> builder(MarshallingType.SDK_POJO).memberName("TotalImpact")
            .getter(getter(GetAnomaliesRequest::totalImpact)).setter(setter(Builder::totalImpact))
            .constructor(TotalImpactFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalImpact").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetAnomaliesRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetAnomaliesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD,
            DATE_INTERVAL_FIELD, FEEDBACK_FIELD, TOTAL_IMPACT_FIELD, NEXT_PAGE_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String monitorArn;

    private final AnomalyDateInterval dateInterval;

    private final String feedback;

    private final TotalImpactFilter totalImpact;

    private final String nextPageToken;

    private final Integer maxResults;

    private GetAnomaliesRequest(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
        this.dateInterval = builder.dateInterval;
        this.feedback = builder.feedback;
        this.totalImpact = builder.totalImpact;
        this.nextPageToken = builder.nextPageToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name
     *         (ARN).
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an
     * <code>AnomalyEndDate</code> in the specified time range.
     * </p>
     * 
     * @return Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an
     *         <code>AnomalyEndDate</code> in the specified time range.
     */
    public final AnomalyDateInterval dateInterval() {
        return dateInterval;
    }

    /**
     * <p>
     * Filters anomaly results by the feedback field on the anomaly object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link AnomalyFeedbackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackAsString}.
     * </p>
     * 
     * @return Filters anomaly results by the feedback field on the anomaly object.
     * @see AnomalyFeedbackType
     */
    public final AnomalyFeedbackType feedback() {
        return AnomalyFeedbackType.fromValue(feedback);
    }

    /**
     * <p>
     * Filters anomaly results by the feedback field on the anomaly object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link AnomalyFeedbackType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackAsString}.
     * </p>
     * 
     * @return Filters anomaly results by the feedback field on the anomaly object.
     * @see AnomalyFeedbackType
     */
    public final String feedbackAsString() {
        return feedback;
    }

    /**
     * <p>
     * Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies
     * <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200.
     * </p>
     * 
     * @return Filters anomaly results by the total impact field on the anomaly object. For example, you can filter
     *         anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater
     *         than 200.
     */
    public final TotalImpactFilter totalImpact() {
        return totalImpact;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The number of entries a paginated response contains.
     * </p>
     * 
     * @return The number of entries a paginated response contains.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(dateInterval());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalImpact());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomaliesRequest)) {
            return false;
        }
        GetAnomaliesRequest other = (GetAnomaliesRequest) obj;
        return Objects.equals(monitorArn(), other.monitorArn()) && Objects.equals(dateInterval(), other.dateInterval())
                && Objects.equals(feedbackAsString(), other.feedbackAsString())
                && Objects.equals(totalImpact(), other.totalImpact()) && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAnomaliesRequest").add("MonitorArn", monitorArn()).add("DateInterval", dateInterval())
                .add("Feedback", feedbackAsString()).add("TotalImpact", totalImpact()).add("NextPageToken", nextPageToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "DateInterval":
            return Optional.ofNullable(clazz.cast(dateInterval()));
        case "Feedback":
            return Optional.ofNullable(clazz.cast(feedbackAsString()));
        case "TotalImpact":
            return Optional.ofNullable(clazz.cast(totalImpact()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomaliesRequest, T> g) {
        return obj -> g.apply((GetAnomaliesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAnomaliesRequest> {
        /**
         * <p>
         * Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN).
         * </p>
         * 
         * @param monitorArn
         *        Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name
         *        (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an
         * <code>AnomalyEndDate</code> in the specified time range.
         * </p>
         * 
         * @param dateInterval
         *        Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have
         *        an <code>AnomalyEndDate</code> in the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateInterval(AnomalyDateInterval dateInterval);

        /**
         * <p>
         * Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an
         * <code>AnomalyEndDate</code> in the specified time range.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDateInterval.Builder} avoiding the
         * need to create one manually via {@link AnomalyDateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDateInterval.Builder#build()} is called immediately and
         * its result is passed to {@link #dateInterval(AnomalyDateInterval)}.
         * 
         * @param dateInterval
         *        a consumer that will call methods on {@link AnomalyDateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateInterval(AnomalyDateInterval)
         */
        default Builder dateInterval(Consumer<AnomalyDateInterval.Builder> dateInterval) {
            return dateInterval(AnomalyDateInterval.builder().applyMutation(dateInterval).build());
        }

        /**
         * <p>
         * Filters anomaly results by the feedback field on the anomaly object.
         * </p>
         * 
         * @param feedback
         *        Filters anomaly results by the feedback field on the anomaly object.
         * @see AnomalyFeedbackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyFeedbackType
         */
        Builder feedback(String feedback);

        /**
         * <p>
         * Filters anomaly results by the feedback field on the anomaly object.
         * </p>
         * 
         * @param feedback
         *        Filters anomaly results by the feedback field on the anomaly object.
         * @see AnomalyFeedbackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyFeedbackType
         */
        Builder feedback(AnomalyFeedbackType feedback);

        /**
         * <p>
         * Filters anomaly results by the total impact field on the anomaly object. For example, you can filter
         * anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater
         * than 200.
         * </p>
         * 
         * @param totalImpact
         *        Filters anomaly results by the total impact field on the anomaly object. For example, you can filter
         *        anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact
         *        greater than 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalImpact(TotalImpactFilter totalImpact);

        /**
         * <p>
         * Filters anomaly results by the total impact field on the anomaly object. For example, you can filter
         * anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater
         * than 200.
         * </p>
         * This is a convenience method that creates an instance of the {@link TotalImpactFilter.Builder} avoiding the
         * need to create one manually via {@link TotalImpactFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TotalImpactFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #totalImpact(TotalImpactFilter)}.
         * 
         * @param totalImpact
         *        a consumer that will call methods on {@link TotalImpactFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalImpact(TotalImpactFilter)
         */
        default Builder totalImpact(Consumer<TotalImpactFilter.Builder> totalImpact) {
            return totalImpact(TotalImpactFilter.builder().applyMutation(totalImpact).build());
        }

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The number of entries a paginated response contains.
         * </p>
         * 
         * @param maxResults
         *        The number of entries a paginated response contains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String monitorArn;

        private AnomalyDateInterval dateInterval;

        private String feedback;

        private TotalImpactFilter totalImpact;

        private String nextPageToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomaliesRequest model) {
            super(model);
            monitorArn(model.monitorArn);
            dateInterval(model.dateInterval);
            feedback(model.feedback);
            totalImpact(model.totalImpact);
            nextPageToken(model.nextPageToken);
            maxResults(model.maxResults);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final AnomalyDateInterval.Builder getDateInterval() {
            return dateInterval != null ? dateInterval.toBuilder() : null;
        }

        public final void setDateInterval(AnomalyDateInterval.BuilderImpl dateInterval) {
            this.dateInterval = dateInterval != null ? dateInterval.build() : null;
        }

        @Override
        public final Builder dateInterval(AnomalyDateInterval dateInterval) {
            this.dateInterval = dateInterval;
            return this;
        }

        public final String getFeedback() {
            return feedback;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(AnomalyFeedbackType feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        public final TotalImpactFilter.Builder getTotalImpact() {
            return totalImpact != null ? totalImpact.toBuilder() : null;
        }

        public final void setTotalImpact(TotalImpactFilter.BuilderImpl totalImpact) {
            this.totalImpact = totalImpact != null ? totalImpact.build() : null;
        }

        @Override
        public final Builder totalImpact(TotalImpactFilter totalImpact) {
            this.totalImpact = totalImpact;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAnomaliesRequest build() {
            return new GetAnomaliesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
