/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CostAllocationTagStatusListCopier {
    static List<CostAllocationTagStatusEntry> copy(
            Collection<? extends CostAllocationTagStatusEntry> costAllocationTagStatusListParam) {
        List<CostAllocationTagStatusEntry> list;
        if (costAllocationTagStatusListParam == null || costAllocationTagStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CostAllocationTagStatusEntry> modifiableList = new ArrayList<>();
            costAllocationTagStatusListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CostAllocationTagStatusEntry> copyFromBuilder(
            Collection<? extends CostAllocationTagStatusEntry.Builder> costAllocationTagStatusListParam) {
        List<CostAllocationTagStatusEntry> list;
        if (costAllocationTagStatusListParam == null || costAllocationTagStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CostAllocationTagStatusEntry> modifiableList = new ArrayList<>();
            costAllocationTagStatusListParam.forEach(entry -> {
                CostAllocationTagStatusEntry member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CostAllocationTagStatusEntry.Builder> copyToBuilder(
            Collection<? extends CostAllocationTagStatusEntry> costAllocationTagStatusListParam) {
        List<CostAllocationTagStatusEntry.Builder> list;
        if (costAllocationTagStatusListParam == null || costAllocationTagStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CostAllocationTagStatusEntry.Builder> modifiableList = new ArrayList<>();
            costAllocationTagStatusListParam.forEach(entry -> {
                CostAllocationTagStatusEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
