/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsResponse;

public class ListCostAllocationTagsIterable
implements SdkIterable<ListCostAllocationTagsResponse> {
    private final CostExplorerClient client;
    private final ListCostAllocationTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCostAllocationTagsIterable(CostExplorerClient client, ListCostAllocationTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCostAllocationTagsResponseFetcher();
    }

    public Iterator<ListCostAllocationTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCostAllocationTagsResponseFetcher
    implements SyncPageFetcher<ListCostAllocationTagsResponse> {
        private ListCostAllocationTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListCostAllocationTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCostAllocationTagsResponse nextPage(ListCostAllocationTagsResponse previousPage) {
            if (previousPage == null) {
                return ListCostAllocationTagsIterable.this.client.listCostAllocationTags(ListCostAllocationTagsIterable.this.firstRequest);
            }
            return ListCostAllocationTagsIterable.this.client.listCostAllocationTags((ListCostAllocationTagsRequest)((Object)ListCostAllocationTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

