/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorDimension {
    SERVICE("SERVICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorDimension> VALUE_MAP;
    private final String value;

    private MonitorDimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorDimension> knownValues() {
        EnumSet<MonitorDimension> knownValues = EnumSet.allOf(MonitorDimension.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorDimension.class, MonitorDimension::toString);
    }
}

