/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costandusagereport;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.costandusagereport.model.CostAndUsageReportException;
import software.amazon.awssdk.services.costandusagereport.model.DeleteReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.DeleteReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;
import software.amazon.awssdk.services.costandusagereport.model.DuplicateReportNameException;
import software.amazon.awssdk.services.costandusagereport.model.InternalErrorException;
import software.amazon.awssdk.services.costandusagereport.model.ModifyReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.ModifyReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.model.PutReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.PutReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.model.ReportLimitReachedException;
import software.amazon.awssdk.services.costandusagereport.model.ValidationException;
import software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable;

/**
 * Service client for accessing AWS Cost and Usage Report Service. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The AWS Cost and Usage Report API enables you to programmatically create, query, and delete AWS Cost and Usage report
 * definitions.
 * </p>
 * <p>
 * AWS Cost and Usage reports track the monthly AWS costs and usage associated with your AWS account. The report
 * contains line items for each unique combination of AWS product, usage type, and operation that your AWS account uses.
 * You can configure the AWS Cost and Usage report to show only the data that you want, using the AWS Cost and Usage
 * API.
 * </p>
 * <p>
 * Service Endpoint
 * </p>
 * <p>
 * The AWS Cost and Usage Report API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * cur.us-east-1.amazonaws.com
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CostAndUsageReportClient extends AwsClient {
    String SERVICE_NAME = "cur";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cur";

    /**
     * <p>
     * Deletes the specified report.
     * </p>
     *
     * @param deleteReportDefinitionRequest
     *        Deletes the specified report.
     * @return Result of the DeleteReportDefinition operation returned by the service.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DeleteReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReportDefinitionResponse deleteReportDefinition(DeleteReportDefinitionRequest deleteReportDefinitionRequest)
            throws InternalErrorException, ValidationException, AwsServiceException, SdkClientException,
            CostAndUsageReportException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReportDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReportDefinitionRequest.Builder} to create a
     *        request. Deletes the specified report.
     * @return Result of the DeleteReportDefinition operation returned by the service.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DeleteReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DeleteReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReportDefinitionResponse deleteReportDefinition(
            Consumer<DeleteReportDefinitionRequest.Builder> deleteReportDefinitionRequest) throws InternalErrorException,
            ValidationException, AwsServiceException, SdkClientException, CostAndUsageReportException {
        return deleteReportDefinition(DeleteReportDefinitionRequest.builder().applyMutation(deleteReportDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     *
     * @return Result of the DescribeReportDefinitions operation returned by the service.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DescribeReportDefinitions
     * @see #describeReportDefinitions(DescribeReportDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsResponse describeReportDefinitions() throws InternalErrorException, AwsServiceException,
            SdkClientException, CostAndUsageReportException {
        return describeReportDefinitions(DescribeReportDefinitionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        Requests a list of AWS Cost and Usage reports owned by the account.
     * @return Result of the DescribeReportDefinitions operation returned by the service.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsResponse describeReportDefinitions(
            DescribeReportDefinitionsRequest describeReportDefinitionsRequest) throws InternalErrorException,
            AwsServiceException, SdkClientException, CostAndUsageReportException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReportDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReportDefinitionsRequest.Builder} to create a
     *        request. Requests a list of AWS Cost and Usage reports owned by the account.
     * @return Result of the DescribeReportDefinitions operation returned by the service.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsResponse describeReportDefinitions(
            Consumer<DescribeReportDefinitionsRequest.Builder> describeReportDefinitionsRequest) throws InternalErrorException,
            AwsServiceException, SdkClientException, CostAndUsageReportException {
        return describeReportDefinitions(DescribeReportDefinitionsRequest.builder()
                .applyMutation(describeReportDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client.describeReportDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client
     *             .describeReportDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client.describeReportDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DescribeReportDefinitions
     * @see #describeReportDefinitionsPaginator(DescribeReportDefinitionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsIterable describeReportDefinitionsPaginator() throws InternalErrorException,
            AwsServiceException, SdkClientException, CostAndUsageReportException {
        return describeReportDefinitionsPaginator(DescribeReportDefinitionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client.describeReportDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client
     *             .describeReportDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client.describeReportDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        Requests a list of AWS Cost and Usage reports owned by the account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsIterable describeReportDefinitionsPaginator(
            DescribeReportDefinitionsRequest describeReportDefinitionsRequest) throws InternalErrorException,
            AwsServiceException, SdkClientException, CostAndUsageReportException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS Cost and Usage reports available to this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client.describeReportDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client
     *             .describeReportDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costandusagereport.paginators.DescribeReportDefinitionsIterable responses = client.describeReportDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReportDefinitions(software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReportDefinitionsRequest#builder()}
     * </p>
     *
     * @param describeReportDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReportDefinitionsRequest.Builder} to create a
     *        request. Requests a list of AWS Cost and Usage reports owned by the account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.DescribeReportDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/DescribeReportDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReportDefinitionsIterable describeReportDefinitionsPaginator(
            Consumer<DescribeReportDefinitionsRequest.Builder> describeReportDefinitionsRequest) throws InternalErrorException,
            AwsServiceException, SdkClientException, CostAndUsageReportException {
        return describeReportDefinitionsPaginator(DescribeReportDefinitionsRequest.builder()
                .applyMutation(describeReportDefinitionsRequest).build());
    }

    /**
     * <p>
     * Allows you to programatically update your report preferences.
     * </p>
     *
     * @param modifyReportDefinitionRequest
     * @return Result of the ModifyReportDefinition operation returned by the service.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.ModifyReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReportDefinitionResponse modifyReportDefinition(ModifyReportDefinitionRequest modifyReportDefinitionRequest)
            throws InternalErrorException, ValidationException, AwsServiceException, SdkClientException,
            CostAndUsageReportException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to programatically update your report preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyReportDefinitionRequest#builder()}
     * </p>
     *
     * @param modifyReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyReportDefinitionRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyReportDefinition operation returned by the service.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.ModifyReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/ModifyReportDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReportDefinitionResponse modifyReportDefinition(
            Consumer<ModifyReportDefinitionRequest.Builder> modifyReportDefinitionRequest) throws InternalErrorException,
            ValidationException, AwsServiceException, SdkClientException, CostAndUsageReportException {
        return modifyReportDefinition(ModifyReportDefinitionRequest.builder().applyMutation(modifyReportDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new report using the description that you provide.
     * </p>
     *
     * @param putReportDefinitionRequest
     *        Creates a Cost and Usage Report.
     * @return Result of the PutReportDefinition operation returned by the service.
     * @throws DuplicateReportNameException
     *         A report with the specified name already exists in the account. Specify a different report name.
     * @throws ReportLimitReachedException
     *         This account already has five reports defined. To define a new report, you must delete an existing
     *         report.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.PutReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default PutReportDefinitionResponse putReportDefinition(PutReportDefinitionRequest putReportDefinitionRequest)
            throws DuplicateReportNameException, ReportLimitReachedException, InternalErrorException, ValidationException,
            AwsServiceException, SdkClientException, CostAndUsageReportException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new report using the description that you provide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link PutReportDefinitionRequest#builder()}
     * </p>
     *
     * @param putReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link PutReportDefinitionRequest.Builder} to create a
     *        request. Creates a Cost and Usage Report.
     * @return Result of the PutReportDefinition operation returned by the service.
     * @throws DuplicateReportNameException
     *         A report with the specified name already exists in the account. Specify a different report name.
     * @throws ReportLimitReachedException
     *         This account already has five reports defined. To define a new report, you must delete an existing
     *         report.
     * @throws InternalErrorException
     *         An error on the server occurred during the processing of your request. Try again later.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CostAndUsageReportException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CostAndUsageReportClient.PutReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default PutReportDefinitionResponse putReportDefinition(
            Consumer<PutReportDefinitionRequest.Builder> putReportDefinitionRequest) throws DuplicateReportNameException,
            ReportLimitReachedException, InternalErrorException, ValidationException, AwsServiceException, SdkClientException,
            CostAndUsageReportException {
        return putReportDefinition(PutReportDefinitionRequest.builder().applyMutation(putReportDefinitionRequest).build());
    }

    /**
     * Create a {@link CostAndUsageReportClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CostAndUsageReportClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CostAndUsageReportClient}.
     */
    static CostAndUsageReportClientBuilder builder() {
        return new DefaultCostAndUsageReportClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CostAndUsageReportServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
