/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.Section;
import software.amazon.awssdk.services.connectcases.model.SectionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayoutSections
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayoutSections> {
    private static final SdkField<List<Section>> SECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sections").getter(LayoutSections.getter(LayoutSections::sections)).setter(LayoutSections.setter(Builder::sections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Section::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Section> sections;

    private LayoutSections(BuilderImpl builder) {
        this.sections = builder.sections;
    }

    public final boolean hasSections() {
        return this.sections != null && !(this.sections instanceof SdkAutoConstructList);
    }

    public final List<Section> sections() {
        return this.sections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSections() ? this.sections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayoutSections)) {
            return false;
        }
        LayoutSections other = (LayoutSections)obj;
        return this.hasSections() == other.hasSections() && Objects.equals(this.sections(), other.sections());
    }

    public final String toString() {
        return ToString.builder((String)"LayoutSections").add("Sections", this.hasSections() ? this.sections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sections": {
                return Optional.ofNullable(clazz.cast(this.sections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LayoutSections, T> g) {
        return obj -> g.apply((LayoutSections)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Section> sections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LayoutSections model) {
            this.sections(model.sections);
        }

        public final List<Section.Builder> getSections() {
            List<Section.Builder> result = SectionsListCopier.copyToBuilder(this.sections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSections(Collection<Section.BuilderImpl> sections) {
            this.sections = SectionsListCopier.copyFromBuilder(sections);
        }

        @Override
        public final Builder sections(Collection<Section> sections) {
            this.sections = SectionsListCopier.copy(sections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sections(Section ... sections) {
            this.sections(Arrays.asList(sections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sections(Consumer<Section.Builder> ... sections) {
            this.sections(Stream.of(sections).map(c -> (Section)((Section.Builder)Section.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LayoutSections build() {
            return new LayoutSections(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayoutSections> {
        public Builder sections(Collection<Section> var1);

        public Builder sections(Section ... var1);

        public Builder sections(Consumer<Section.Builder> ... var1);
    }
}

