/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.DomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, CreateDomainResponse> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainArn").getter(CreateDomainResponse.getter(CreateDomainResponse::domainArn)).setter(CreateDomainResponse.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainArn").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(CreateDomainResponse.getter(CreateDomainResponse::domainId)).setter(CreateDomainResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainStatus").getter(CreateDomainResponse.getter(CreateDomainResponse::domainStatusAsString)).setter(CreateDomainResponse.setter(Builder::domainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD, DOMAIN_ID_FIELD, DOMAIN_STATUS_FIELD));
    private final String domainArn;
    private final String domainId;
    private final String domainStatus;

    private CreateDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainArn = builder.domainArn;
        this.domainId = builder.domainId;
        this.domainStatus = builder.domainStatus;
    }

    public final String domainArn() {
        return this.domainArn;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final DomainStatus domainStatus() {
        return DomainStatus.fromValue(this.domainStatus);
    }

    public final String domainStatusAsString() {
        return this.domainStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainResponse)) {
            return false;
        }
        CreateDomainResponse other = (CreateDomainResponse)((Object)obj);
        return Objects.equals(this.domainArn(), other.domainArn()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainStatusAsString(), other.domainStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainResponse").add("DomainArn", (Object)this.domainArn()).add("DomainId", (Object)this.domainId()).add("DomainStatus", (Object)this.domainStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "domainStatus": {
                return Optional.ofNullable(clazz.cast(this.domainStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainResponse, T> g) {
        return obj -> g.apply((CreateDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private String domainArn;
        private String domainId;
        private String domainStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainResponse model) {
            super(model);
            this.domainArn(model.domainArn);
            this.domainId(model.domainId);
            this.domainStatus(model.domainStatus);
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainStatus() {
            return this.domainStatus;
        }

        public final void setDomainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
        }

        @Override
        public final Builder domainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public final Builder domainStatus(DomainStatus domainStatus) {
            this.domainStatus(domainStatus == null ? null : domainStatus.toString());
            return this;
        }

        @Override
        public CreateDomainResponse build() {
            return new CreateDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainResponse> {
        public Builder domainArn(String var1);

        public Builder domainId(String var1);

        public Builder domainStatus(String var1);

        public Builder domainStatus(DomainStatus var1);
    }
}

