/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.model.ListLayoutsRequest;
import software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse;

public class ListLayoutsIterable
implements SdkIterable<ListLayoutsResponse> {
    private final ConnectCasesClient client;
    private final ListLayoutsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLayoutsIterable(ConnectCasesClient client, ListLayoutsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLayoutsResponseFetcher();
    }

    public Iterator<ListLayoutsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLayoutsResponseFetcher
    implements SyncPageFetcher<ListLayoutsResponse> {
        private ListLayoutsResponseFetcher() {
        }

        public boolean hasNextPage(ListLayoutsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLayoutsResponse nextPage(ListLayoutsResponse previousPage) {
            if (previousPage == null) {
                return ListLayoutsIterable.this.client.listLayouts(ListLayoutsIterable.this.firstRequest);
            }
            return ListLayoutsIterable.this.client.listLayouts((ListLayoutsRequest)((Object)ListLayoutsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

