/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse;
import software.amazon.awssdk.services.connect.model.SecurityKey;

public class ListSecurityKeysPublisher
implements SdkPublisher<ListSecurityKeysResponse> {
    private final ConnectAsyncClient client;
    private final ListSecurityKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityKeysPublisher(ConnectAsyncClient client, ListSecurityKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityKeysPublisher(ConnectAsyncClient client, ListSecurityKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityKey> securityKeys() {
        Function<ListSecurityKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityKeys() != null) {
                return response.securityKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityKeysResponseFetcher
    implements AsyncPageFetcher<ListSecurityKeysResponse> {
        private ListSecurityKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityKeysResponse> nextPage(ListSecurityKeysResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityKeysPublisher.this.client.listSecurityKeys(ListSecurityKeysPublisher.this.firstRequest);
            }
            return ListSecurityKeysPublisher.this.client.listSecurityKeys((ListSecurityKeysRequest)((Object)ListSecurityKeysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

