/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QuickConnectType {
    USER("USER"),
    QUEUE("QUEUE"),
    PHONE_NUMBER("PHONE_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QuickConnectType> VALUE_MAP;
    private final String value;

    private QuickConnectType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QuickConnectType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QuickConnectType> knownValues() {
        EnumSet<QuickConnectType> knownValues = EnumSet.allOf(QuickConnectType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QuickConnectType.class, QuickConnectType::toString);
    }
}

