/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.DefaultVocabulary;
import software.amazon.awssdk.services.connect.model.DefaultVocabularyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDefaultVocabulariesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListDefaultVocabulariesResponse> {
    private static final SdkField<List<DefaultVocabulary>> DEFAULT_VOCABULARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultVocabularyList").getter(ListDefaultVocabulariesResponse.getter(ListDefaultVocabulariesResponse::defaultVocabularyList)).setter(ListDefaultVocabulariesResponse.setter(Builder::defaultVocabularyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVocabularyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DefaultVocabulary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDefaultVocabulariesResponse.getter(ListDefaultVocabulariesResponse::nextToken)).setter(ListDefaultVocabulariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VOCABULARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<DefaultVocabulary> defaultVocabularyList;
    private final String nextToken;

    private ListDefaultVocabulariesResponse(BuilderImpl builder) {
        super(builder);
        this.defaultVocabularyList = builder.defaultVocabularyList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDefaultVocabularyList() {
        return this.defaultVocabularyList != null && !(this.defaultVocabularyList instanceof SdkAutoConstructList);
    }

    public final List<DefaultVocabulary> defaultVocabularyList() {
        return this.defaultVocabularyList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultVocabularyList() ? this.defaultVocabularyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDefaultVocabulariesResponse)) {
            return false;
        }
        ListDefaultVocabulariesResponse other = (ListDefaultVocabulariesResponse)((Object)obj);
        return this.hasDefaultVocabularyList() == other.hasDefaultVocabularyList() && Objects.equals(this.defaultVocabularyList(), other.defaultVocabularyList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDefaultVocabulariesResponse").add("DefaultVocabularyList", this.hasDefaultVocabularyList() ? this.defaultVocabularyList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultVocabularyList": {
                return Optional.ofNullable(clazz.cast(this.defaultVocabularyList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDefaultVocabulariesResponse, T> g) {
        return obj -> g.apply((ListDefaultVocabulariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<DefaultVocabulary> defaultVocabularyList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDefaultVocabulariesResponse model) {
            super(model);
            this.defaultVocabularyList(model.defaultVocabularyList);
            this.nextToken(model.nextToken);
        }

        public final List<DefaultVocabulary.Builder> getDefaultVocabularyList() {
            List<DefaultVocabulary.Builder> result = DefaultVocabularyListCopier.copyToBuilder(this.defaultVocabularyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultVocabularyList(Collection<DefaultVocabulary.BuilderImpl> defaultVocabularyList) {
            this.defaultVocabularyList = DefaultVocabularyListCopier.copyFromBuilder(defaultVocabularyList);
        }

        @Override
        public final Builder defaultVocabularyList(Collection<DefaultVocabulary> defaultVocabularyList) {
            this.defaultVocabularyList = DefaultVocabularyListCopier.copy(defaultVocabularyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultVocabularyList(DefaultVocabulary ... defaultVocabularyList) {
            this.defaultVocabularyList(Arrays.asList(defaultVocabularyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultVocabularyList(Consumer<DefaultVocabulary.Builder> ... defaultVocabularyList) {
            this.defaultVocabularyList(Stream.of(defaultVocabularyList).map(c -> (DefaultVocabulary)((DefaultVocabulary.Builder)DefaultVocabulary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDefaultVocabulariesResponse build() {
            return new ListDefaultVocabulariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDefaultVocabulariesResponse> {
        public Builder defaultVocabularyList(Collection<DefaultVocabulary> var1);

        public Builder defaultVocabularyList(DefaultVocabulary ... var1);

        public Builder defaultVocabularyList(Consumer<DefaultVocabulary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

