/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateRoutingProfileQueuesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, AssociateRoutingProfileQueuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(AssociateRoutingProfileQueuesRequest.getter(AssociateRoutingProfileQueuesRequest::instanceId)).setter(AssociateRoutingProfileQueuesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(AssociateRoutingProfileQueuesRequest.getter(AssociateRoutingProfileQueuesRequest::routingProfileId)).setter(AssociateRoutingProfileQueuesRequest.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<List<RoutingProfileQueueConfig>> QUEUE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueueConfigs").getter(AssociateRoutingProfileQueuesRequest.getter(AssociateRoutingProfileQueuesRequest::queueConfigs)).setter(AssociateRoutingProfileQueuesRequest.setter(Builder::queueConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileQueueConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ROUTING_PROFILE_ID_FIELD, QUEUE_CONFIGS_FIELD));
    private final String instanceId;
    private final String routingProfileId;
    private final List<RoutingProfileQueueConfig> queueConfigs;

    private AssociateRoutingProfileQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.queueConfigs = builder.queueConfigs;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String routingProfileId() {
        return this.routingProfileId;
    }

    public final boolean hasQueueConfigs() {
        return this.queueConfigs != null && !(this.queueConfigs instanceof SdkAutoConstructList);
    }

    public final List<RoutingProfileQueueConfig> queueConfigs() {
        return this.queueConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueConfigs() ? this.queueConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRoutingProfileQueuesRequest)) {
            return false;
        }
        AssociateRoutingProfileQueuesRequest other = (AssociateRoutingProfileQueuesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && this.hasQueueConfigs() == other.hasQueueConfigs() && Objects.equals(this.queueConfigs(), other.queueConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateRoutingProfileQueuesRequest").add("InstanceId", (Object)this.instanceId()).add("RoutingProfileId", (Object)this.routingProfileId()).add("QueueConfigs", this.hasQueueConfigs() ? this.queueConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "QueueConfigs": {
                return Optional.ofNullable(clazz.cast(this.queueConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateRoutingProfileQueuesRequest, T> g) {
        return obj -> g.apply((AssociateRoutingProfileQueuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String routingProfileId;
        private List<RoutingProfileQueueConfig> queueConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRoutingProfileQueuesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.routingProfileId(model.routingProfileId);
            this.queueConfigs(model.queueConfigs);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final List<RoutingProfileQueueConfig.Builder> getQueueConfigs() {
            List<RoutingProfileQueueConfig.Builder> result = RoutingProfileQueueConfigListCopier.copyToBuilder(this.queueConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueueConfigs(Collection<RoutingProfileQueueConfig.BuilderImpl> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copyFromBuilder(queueConfigs);
        }

        @Override
        public final Builder queueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copy(queueConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(RoutingProfileQueueConfig ... queueConfigs) {
            this.queueConfigs(Arrays.asList(queueConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder> ... queueConfigs) {
            this.queueConfigs(Stream.of(queueConfigs).map(c -> (RoutingProfileQueueConfig)((RoutingProfileQueueConfig.Builder)RoutingProfileQueueConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateRoutingProfileQueuesRequest build() {
            return new AssociateRoutingProfileQueuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateRoutingProfileQueuesRequest> {
        public Builder instanceId(String var1);

        public Builder routingProfileId(String var1);

        public Builder queueConfigs(Collection<RoutingProfileQueueConfig> var1);

        public Builder queueConfigs(RoutingProfileQueueConfig ... var1);

        public Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

