/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;

public class GetComplianceDetailsByResourceIterable
implements SdkIterable<GetComplianceDetailsByResourceResponse> {
    private final ConfigClient client;
    private final GetComplianceDetailsByResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetComplianceDetailsByResourceIterable(ConfigClient client, GetComplianceDetailsByResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetComplianceDetailsByResourceResponseFetcher();
    }

    public Iterator<GetComplianceDetailsByResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationResult> evaluationResults() {
        Function<GetComplianceDetailsByResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetComplianceDetailsByResourceResponseFetcher
    implements SyncPageFetcher<GetComplianceDetailsByResourceResponse> {
        private GetComplianceDetailsByResourceResponseFetcher() {
        }

        public boolean hasNextPage(GetComplianceDetailsByResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetComplianceDetailsByResourceResponse nextPage(GetComplianceDetailsByResourceResponse previousPage) {
            if (previousPage == null) {
                return GetComplianceDetailsByResourceIterable.this.client.getComplianceDetailsByResource(GetComplianceDetailsByResourceIterable.this.firstRequest);
            }
            return GetComplianceDetailsByResourceIterable.this.client.getComplianceDetailsByResource((GetComplianceDetailsByResourceRequest)((Object)GetComplianceDetailsByResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

