/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;

public class GetAggregateDiscoveredResourceCountsIterable
implements SdkIterable<GetAggregateDiscoveredResourceCountsResponse> {
    private final ConfigClient client;
    private final GetAggregateDiscoveredResourceCountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAggregateDiscoveredResourceCountsIterable(ConfigClient client, GetAggregateDiscoveredResourceCountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAggregateDiscoveredResourceCountsResponseFetcher();
    }

    public Iterator<GetAggregateDiscoveredResourceCountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetAggregateDiscoveredResourceCountsResponseFetcher
    implements SyncPageFetcher<GetAggregateDiscoveredResourceCountsResponse> {
        private GetAggregateDiscoveredResourceCountsResponseFetcher() {
        }

        public boolean hasNextPage(GetAggregateDiscoveredResourceCountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAggregateDiscoveredResourceCountsResponse nextPage(GetAggregateDiscoveredResourceCountsResponse previousPage) {
            if (previousPage == null) {
                return GetAggregateDiscoveredResourceCountsIterable.this.client.getAggregateDiscoveredResourceCounts(GetAggregateDiscoveredResourceCountsIterable.this.firstRequest);
            }
            return GetAggregateDiscoveredResourceCountsIterable.this.client.getAggregateDiscoveredResourceCounts((GetAggregateDiscoveredResourceCountsRequest)((Object)GetAggregateDiscoveredResourceCountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

