/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.PendingAggregationRequest;

public class DescribePendingAggregationRequestsIterable
implements SdkIterable<DescribePendingAggregationRequestsResponse> {
    private final ConfigClient client;
    private final DescribePendingAggregationRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePendingAggregationRequestsIterable(ConfigClient client, DescribePendingAggregationRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePendingAggregationRequestsResponseFetcher();
    }

    public Iterator<DescribePendingAggregationRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PendingAggregationRequest> pendingAggregationRequests() {
        Function<DescribePendingAggregationRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pendingAggregationRequests() != null) {
                return response.pendingAggregationRequests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePendingAggregationRequestsResponseFetcher
    implements SyncPageFetcher<DescribePendingAggregationRequestsResponse> {
        private DescribePendingAggregationRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePendingAggregationRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePendingAggregationRequestsResponse nextPage(DescribePendingAggregationRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribePendingAggregationRequestsIterable.this.client.describePendingAggregationRequests(DescribePendingAggregationRequestsIterable.this.firstRequest);
            }
            return DescribePendingAggregationRequestsIterable.this.client.describePendingAggregationRequests((DescribePendingAggregationRequestsRequest)((Object)DescribePendingAggregationRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

