/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;

public class DescribeConfigRuleEvaluationStatusIterable
implements SdkIterable<DescribeConfigRuleEvaluationStatusResponse> {
    private final ConfigClient client;
    private final DescribeConfigRuleEvaluationStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConfigRuleEvaluationStatusIterable(ConfigClient client, DescribeConfigRuleEvaluationStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConfigRuleEvaluationStatusResponseFetcher();
    }

    public Iterator<DescribeConfigRuleEvaluationStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigRuleEvaluationStatus> configRulesEvaluationStatus() {
        Function<DescribeConfigRuleEvaluationStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.configRulesEvaluationStatus() != null) {
                return response.configRulesEvaluationStatus().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConfigRuleEvaluationStatusResponseFetcher
    implements SyncPageFetcher<DescribeConfigRuleEvaluationStatusResponse> {
        private DescribeConfigRuleEvaluationStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigRuleEvaluationStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConfigRuleEvaluationStatusResponse nextPage(DescribeConfigRuleEvaluationStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigRuleEvaluationStatusIterable.this.client.describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusIterable.this.firstRequest);
            }
            return DescribeConfigRuleEvaluationStatusIterable.this.client.describeConfigRuleEvaluationStatus((DescribeConfigRuleEvaluationStatusRequest)((Object)DescribeConfigRuleEvaluationStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

