/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.EvaluationContext;
import software.amazon.awssdk.services.config.model.EvaluationMode;
import software.amazon.awssdk.services.config.model.ResourceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartResourceEvaluationRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, StartResourceEvaluationRequest> {
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(StartResourceEvaluationRequest.getter(StartResourceEvaluationRequest::resourceDetails)).setter(StartResourceEvaluationRequest.setter(Builder::resourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()}).build();
    private static final SdkField<EvaluationContext> EVALUATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationContext").getter(StartResourceEvaluationRequest.getter(StartResourceEvaluationRequest::evaluationContext)).setter(StartResourceEvaluationRequest.setter(Builder::evaluationContext)).constructor(EvaluationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()}).build();
    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationMode").getter(StartResourceEvaluationRequest.getter(StartResourceEvaluationRequest::evaluationModeAsString)).setter(StartResourceEvaluationRequest.setter(Builder::evaluationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()}).build();
    private static final SdkField<Integer> EVALUATION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationTimeout").getter(StartResourceEvaluationRequest.getter(StartResourceEvaluationRequest::evaluationTimeout)).setter(StartResourceEvaluationRequest.setter(Builder::evaluationTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationTimeout").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartResourceEvaluationRequest.getter(StartResourceEvaluationRequest::clientToken)).setter(StartResourceEvaluationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_DETAILS_FIELD, EVALUATION_CONTEXT_FIELD, EVALUATION_MODE_FIELD, EVALUATION_TIMEOUT_FIELD, CLIENT_TOKEN_FIELD));
    private final ResourceDetails resourceDetails;
    private final EvaluationContext evaluationContext;
    private final String evaluationMode;
    private final Integer evaluationTimeout;
    private final String clientToken;

    private StartResourceEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceDetails = builder.resourceDetails;
        this.evaluationContext = builder.evaluationContext;
        this.evaluationMode = builder.evaluationMode;
        this.evaluationTimeout = builder.evaluationTimeout;
        this.clientToken = builder.clientToken;
    }

    public final ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public final EvaluationContext evaluationContext() {
        return this.evaluationContext;
    }

    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(this.evaluationMode);
    }

    public final String evaluationModeAsString() {
        return this.evaluationMode;
    }

    public final Integer evaluationTimeout() {
        return this.evaluationTimeout;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceEvaluationRequest)) {
            return false;
        }
        StartResourceEvaluationRequest other = (StartResourceEvaluationRequest)((Object)obj);
        return Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.evaluationContext(), other.evaluationContext()) && Objects.equals(this.evaluationModeAsString(), other.evaluationModeAsString()) && Objects.equals(this.evaluationTimeout(), other.evaluationTimeout()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartResourceEvaluationRequest").add("ResourceDetails", (Object)this.resourceDetails()).add("EvaluationContext", (Object)this.evaluationContext()).add("EvaluationMode", (Object)this.evaluationModeAsString()).add("EvaluationTimeout", (Object)this.evaluationTimeout()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "EvaluationContext": {
                return Optional.ofNullable(clazz.cast(this.evaluationContext()));
            }
            case "EvaluationMode": {
                return Optional.ofNullable(clazz.cast(this.evaluationModeAsString()));
            }
            case "EvaluationTimeout": {
                return Optional.ofNullable(clazz.cast(this.evaluationTimeout()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartResourceEvaluationRequest, T> g) {
        return obj -> g.apply((StartResourceEvaluationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private ResourceDetails resourceDetails;
        private EvaluationContext evaluationContext;
        private String evaluationMode;
        private Integer evaluationTimeout;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceEvaluationRequest model) {
            super(model);
            this.resourceDetails(model.resourceDetails);
            this.evaluationContext(model.evaluationContext);
            this.evaluationMode(model.evaluationMode);
            this.evaluationTimeout(model.evaluationTimeout);
            this.clientToken(model.clientToken);
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final EvaluationContext.Builder getEvaluationContext() {
            return this.evaluationContext != null ? this.evaluationContext.toBuilder() : null;
        }

        public final void setEvaluationContext(EvaluationContext.BuilderImpl evaluationContext) {
            this.evaluationContext = evaluationContext != null ? evaluationContext.build() : null;
        }

        @Override
        public final Builder evaluationContext(EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getEvaluationMode() {
            return this.evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final Integer getEvaluationTimeout() {
            return this.evaluationTimeout;
        }

        public final void setEvaluationTimeout(Integer evaluationTimeout) {
            this.evaluationTimeout = evaluationTimeout;
        }

        @Override
        public final Builder evaluationTimeout(Integer evaluationTimeout) {
            this.evaluationTimeout = evaluationTimeout;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartResourceEvaluationRequest build() {
            return new StartResourceEvaluationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartResourceEvaluationRequest> {
        public Builder resourceDetails(ResourceDetails var1);

        default public Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(resourceDetails)).build());
        }

        public Builder evaluationContext(EvaluationContext var1);

        default public Builder evaluationContext(Consumer<EvaluationContext.Builder> evaluationContext) {
            return this.evaluationContext((EvaluationContext)((EvaluationContext.Builder)EvaluationContext.builder().applyMutation(evaluationContext)).build());
        }

        public Builder evaluationMode(String var1);

        public Builder evaluationMode(EvaluationMode var1);

        public Builder evaluationTimeout(Integer var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

