/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EvaluationMode {
    DETECTIVE("DETECTIVE"),
    PROACTIVE("PROACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluationMode> VALUE_MAP;
    private final String value;

    private EvaluationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EvaluationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EvaluationMode> knownValues() {
        EnumSet<EvaluationMode> knownValues = EnumSet.allOf(EvaluationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EvaluationMode.class, EvaluationMode::toString);
    }
}

