/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEcsServiceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEcsServiceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest;
import software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse;
import software.amazon.awssdk.services.computeoptimizer.paginators.DescribeRecommendationExportJobsPublisher;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetEnrollmentStatusesForOrganizationPublisher;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetLambdaFunctionRecommendationsPublisher;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationPreferencesPublisher;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationSummariesPublisher;

/**
 * Service client for accessing AWS Compute Optimizer asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Compute Optimizer is a service that analyzes the configuration and utilization metrics of your Amazon Web Services
 * compute resources, such as Amazon EC2 instances, Amazon EC2 Auto Scaling groups, Lambda functions, Amazon EBS
 * volumes, and Amazon ECS services on Fargate. It reports whether your resources are optimal, and generates
 * optimization recommendations to reduce the cost and improve the performance of your workloads. Compute Optimizer also
 * provides recent utilization metric data, in addition to projected utilization metric data for the recommendations,
 * which you can use to evaluate which recommendation provides the best price-performance trade-off. The analysis of
 * your usage patterns can help you decide when to move or resize your running resources, and still meet your
 * performance and capacity requirements. For more information about Compute Optimizer, including the required
 * permissions to use the service, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/">Compute
 * Optimizer User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ComputeOptimizerAsyncClient extends AwsClient {
    String SERVICE_NAME = "compute-optimizer";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "compute-optimizer";

    /**
     * <p>
     * Deletes a recommendation preference, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param deleteRecommendationPreferencesRequest
     * @return A Java Future containing the result of the DeleteRecommendationPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.DeleteRecommendationPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DeleteRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecommendationPreferencesResponse> deleteRecommendationPreferences(
            DeleteRecommendationPreferencesRequest deleteRecommendationPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a recommendation preference, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecommendationPreferencesRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRecommendationPreferencesRequest#builder()}
     * </p>
     *
     * @param deleteRecommendationPreferencesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecommendationPreferencesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRecommendationPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.DeleteRecommendationPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DeleteRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecommendationPreferencesResponse> deleteRecommendationPreferences(
            Consumer<DeleteRecommendationPreferencesRequest.Builder> deleteRecommendationPreferencesRequest) {
        return deleteRecommendationPreferences(DeleteRecommendationPreferencesRequest.builder()
                .applyMutation(deleteRecommendationPreferencesRequest).build());
    }

    /**
     * <p>
     * Describes recommendation export jobs created in the last seven days.
     * </p>
     * <p>
     * Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to
     * request an export of your recommendations. Then use the <a>DescribeRecommendationExportJobs</a> action to view
     * your export jobs.
     * </p>
     *
     * @param describeRecommendationExportJobsRequest
     * @return A Java Future containing the result of the DescribeRecommendationExportJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.DescribeRecommendationExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRecommendationExportJobsResponse> describeRecommendationExportJobs(
            DescribeRecommendationExportJobsRequest describeRecommendationExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes recommendation export jobs created in the last seven days.
     * </p>
     * <p>
     * Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to
     * request an export of your recommendations. Then use the <a>DescribeRecommendationExportJobs</a> action to view
     * your export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationExportJobsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRecommendationExportJobsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecommendationExportJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRecommendationExportJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.DescribeRecommendationExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRecommendationExportJobsResponse> describeRecommendationExportJobs(
            Consumer<DescribeRecommendationExportJobsRequest.Builder> describeRecommendationExportJobsRequest) {
        return describeRecommendationExportJobs(DescribeRecommendationExportJobsRequest.builder()
                .applyMutation(describeRecommendationExportJobsRequest).build());
    }

    /**
     * <p>
     * Describes recommendation export jobs created in the last seven days.
     * </p>
     * <p>
     * Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to
     * request an export of your recommendations. Then use the <a>DescribeRecommendationExportJobs</a> action to view
     * your export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRecommendationExportJobs(software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.DescribeRecommendationExportJobsPublisher publisher = client.describeRecommendationExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.DescribeRecommendationExportJobsPublisher publisher = client.describeRecommendationExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendationExportJobs(software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRecommendationExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.DescribeRecommendationExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationExportJobsPublisher describeRecommendationExportJobsPaginator(
            DescribeRecommendationExportJobsRequest describeRecommendationExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes recommendation export jobs created in the last seven days.
     * </p>
     * <p>
     * Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to
     * request an export of your recommendations. Then use the <a>DescribeRecommendationExportJobs</a> action to view
     * your export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRecommendationExportJobs(software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.DescribeRecommendationExportJobsPublisher publisher = client.describeRecommendationExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.DescribeRecommendationExportJobsPublisher publisher = client.describeRecommendationExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendationExportJobs(software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationExportJobsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRecommendationExportJobsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecommendationExportJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.DescribeRecommendationExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationExportJobsPublisher describeRecommendationExportJobsPaginator(
            Consumer<DescribeRecommendationExportJobsRequest.Builder> describeRecommendationExportJobsRequest) {
        return describeRecommendationExportJobsPaginator(DescribeRecommendationExportJobsRequest.builder()
                .applyMutation(describeRecommendationExportJobsRequest).build());
    }

    /**
     * <p>
     * Exports optimization recommendations for Auto Scaling groups.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportAutoScalingGroupRecommendationsRequest
     * @return A Java Future containing the result of the ExportAutoScalingGroupRecommendations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportAutoScalingGroupRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportAutoScalingGroupRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportAutoScalingGroupRecommendationsResponse> exportAutoScalingGroupRecommendations(
            ExportAutoScalingGroupRecommendationsRequest exportAutoScalingGroupRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports optimization recommendations for Auto Scaling groups.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ExportAutoScalingGroupRecommendationsRequest.Builder} avoiding the need to create one manually via
     * {@link ExportAutoScalingGroupRecommendationsRequest#builder()}
     * </p>
     *
     * @param exportAutoScalingGroupRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ExportAutoScalingGroupRecommendationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ExportAutoScalingGroupRecommendations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportAutoScalingGroupRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportAutoScalingGroupRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportAutoScalingGroupRecommendationsResponse> exportAutoScalingGroupRecommendations(
            Consumer<ExportAutoScalingGroupRecommendationsRequest.Builder> exportAutoScalingGroupRecommendationsRequest) {
        return exportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest.builder()
                .applyMutation(exportAutoScalingGroupRecommendationsRequest).build());
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon EBS volumes.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportEbsVolumeRecommendationsRequest
     * @return A Java Future containing the result of the ExportEBSVolumeRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportEBSVolumeRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEBSVolumeRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEbsVolumeRecommendationsResponse> exportEBSVolumeRecommendations(
            ExportEbsVolumeRecommendationsRequest exportEbsVolumeRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon EBS volumes.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportEbsVolumeRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ExportEbsVolumeRecommendationsRequest#builder()}
     * </p>
     *
     * @param exportEbsVolumeRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ExportEBSVolumeRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExportEBSVolumeRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportEBSVolumeRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEBSVolumeRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEbsVolumeRecommendationsResponse> exportEBSVolumeRecommendations(
            Consumer<ExportEbsVolumeRecommendationsRequest.Builder> exportEbsVolumeRecommendationsRequest) {
        return exportEBSVolumeRecommendations(ExportEbsVolumeRecommendationsRequest.builder()
                .applyMutation(exportEbsVolumeRecommendationsRequest).build());
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon EC2 instances.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportEc2InstanceRecommendationsRequest
     * @return A Java Future containing the result of the ExportEC2InstanceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportEC2InstanceRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEC2InstanceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEc2InstanceRecommendationsResponse> exportEC2InstanceRecommendations(
            ExportEc2InstanceRecommendationsRequest exportEc2InstanceRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon EC2 instances.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportEc2InstanceRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ExportEc2InstanceRecommendationsRequest#builder()}
     * </p>
     *
     * @param exportEc2InstanceRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ExportEC2InstanceRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExportEC2InstanceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportEC2InstanceRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEC2InstanceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEc2InstanceRecommendationsResponse> exportEC2InstanceRecommendations(
            Consumer<ExportEc2InstanceRecommendationsRequest.Builder> exportEc2InstanceRecommendationsRequest) {
        return exportEC2InstanceRecommendations(ExportEc2InstanceRecommendationsRequest.builder()
                .applyMutation(exportEc2InstanceRecommendationsRequest).build());
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon ECS services on Fargate.
     * </p>
     * <p>
     * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage
     * Service (Amazon S3) bucket that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportEcsServiceRecommendationsRequest
     * @return A Java Future containing the result of the ExportECSServiceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportECSServiceRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportECSServiceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEcsServiceRecommendationsResponse> exportECSServiceRecommendations(
            ExportEcsServiceRecommendationsRequest exportEcsServiceRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon ECS services on Fargate.
     * </p>
     * <p>
     * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage
     * Service (Amazon S3) bucket that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportEcsServiceRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ExportEcsServiceRecommendationsRequest#builder()}
     * </p>
     *
     * @param exportEcsServiceRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ExportECSServiceRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExportECSServiceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportECSServiceRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportECSServiceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportEcsServiceRecommendationsResponse> exportECSServiceRecommendations(
            Consumer<ExportEcsServiceRecommendationsRequest.Builder> exportEcsServiceRecommendationsRequest) {
        return exportECSServiceRecommendations(ExportEcsServiceRecommendationsRequest.builder()
                .applyMutation(exportEcsServiceRecommendationsRequest).build());
    }

    /**
     * <p>
     * Exports optimization recommendations for Lambda functions.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportLambdaFunctionRecommendationsRequest
     * @return A Java Future containing the result of the ExportLambdaFunctionRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportLambdaFunctionRecommendationsResponse> exportLambdaFunctionRecommendations(
            ExportLambdaFunctionRecommendationsRequest exportLambdaFunctionRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports optimization recommendations for Lambda functions.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportLambdaFunctionRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ExportLambdaFunctionRecommendationsRequest#builder()}
     * </p>
     *
     * @param exportLambdaFunctionRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ExportLambdaFunctionRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ExportLambdaFunctionRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.ExportLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportLambdaFunctionRecommendationsResponse> exportLambdaFunctionRecommendations(
            Consumer<ExportLambdaFunctionRecommendationsRequest.Builder> exportLambdaFunctionRecommendationsRequest) {
        return exportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest.builder()
                .applyMutation(exportLambdaFunctionRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns Auto Scaling group recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of
     * requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getAutoScalingGroupRecommendationsRequest
     * @return A Java Future containing the result of the GetAutoScalingGroupRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetAutoScalingGroupRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetAutoScalingGroupRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutoScalingGroupRecommendationsResponse> getAutoScalingGroupRecommendations(
            GetAutoScalingGroupRecommendationsRequest getAutoScalingGroupRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Auto Scaling group recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of
     * requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutoScalingGroupRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetAutoScalingGroupRecommendationsRequest#builder()}
     * </p>
     *
     * @param getAutoScalingGroupRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetAutoScalingGroupRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAutoScalingGroupRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetAutoScalingGroupRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetAutoScalingGroupRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutoScalingGroupRecommendationsResponse> getAutoScalingGroupRecommendations(
            Consumer<GetAutoScalingGroupRecommendationsRequest.Builder> getAutoScalingGroupRecommendationsRequest) {
        return getAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest.builder()
                .applyMutation(getAutoScalingGroupRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For
     * more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getEbsVolumeRecommendationsRequest
     * @return A Java Future containing the result of the GetEBSVolumeRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEBSVolumeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEBSVolumeRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEbsVolumeRecommendationsResponse> getEBSVolumeRecommendations(
            GetEbsVolumeRecommendationsRequest getEbsVolumeRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For
     * more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEbsVolumeRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetEbsVolumeRecommendationsRequest#builder()}
     * </p>
     *
     * @param getEbsVolumeRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetEBSVolumeRecommendationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetEBSVolumeRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEBSVolumeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEBSVolumeRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEbsVolumeRecommendationsResponse> getEBSVolumeRecommendations(
            Consumer<GetEbsVolumeRecommendationsRequest.Builder> getEbsVolumeRecommendationsRequest) {
        return getEBSVolumeRecommendations(GetEbsVolumeRecommendationsRequest.builder()
                .applyMutation(getEbsVolumeRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns Amazon EC2 instance recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a
     * specific set of requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getEc2InstanceRecommendationsRequest
     * @return A Java Future containing the result of the GetEC2InstanceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEC2InstanceRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2InstanceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEc2InstanceRecommendationsResponse> getEC2InstanceRecommendations(
            GetEc2InstanceRecommendationsRequest getEc2InstanceRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Amazon EC2 instance recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a
     * specific set of requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEc2InstanceRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetEc2InstanceRecommendationsRequest#builder()}
     * </p>
     *
     * @param getEc2InstanceRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetEC2InstanceRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetEC2InstanceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEC2InstanceRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2InstanceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEc2InstanceRecommendationsResponse> getEC2InstanceRecommendations(
            Consumer<GetEc2InstanceRecommendationsRequest.Builder> getEc2InstanceRecommendationsRequest) {
        return getEC2InstanceRecommendations(GetEc2InstanceRecommendationsRequest.builder()
                .applyMutation(getEc2InstanceRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
     * </p>
     * <note>
     * <p>
     * The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you
     * run this action. Additionally, the <code>Memory</code> metric is returned only for resources that have the
     * unified CloudWatch agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note>
     *
     * @param getEc2RecommendationProjectedMetricsRequest
     * @return A Java Future containing the result of the GetEC2RecommendationProjectedMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEC2RecommendationProjectedMetrics
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2RecommendationProjectedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEc2RecommendationProjectedMetricsResponse> getEC2RecommendationProjectedMetrics(
            GetEc2RecommendationProjectedMetricsRequest getEc2RecommendationProjectedMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
     * </p>
     * <note>
     * <p>
     * The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you
     * run this action. Additionally, the <code>Memory</code> metric is returned only for resources that have the
     * unified CloudWatch agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEc2RecommendationProjectedMetricsRequest.Builder} avoiding the need to create one manually via
     * {@link GetEc2RecommendationProjectedMetricsRequest#builder()}
     * </p>
     *
     * @param getEc2RecommendationProjectedMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetEC2RecommendationProjectedMetricsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEC2RecommendationProjectedMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEC2RecommendationProjectedMetrics
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2RecommendationProjectedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEc2RecommendationProjectedMetricsResponse> getEC2RecommendationProjectedMetrics(
            Consumer<GetEc2RecommendationProjectedMetricsRequest.Builder> getEc2RecommendationProjectedMetricsRequest) {
        return getEC2RecommendationProjectedMetrics(GetEc2RecommendationProjectedMetricsRequest.builder()
                .applyMutation(getEc2RecommendationProjectedMetricsRequest).build());
    }

    /**
     * <p>
     * Returns the projected metrics of Amazon ECS service recommendations.
     * </p>
     *
     * @param getEcsServiceRecommendationProjectedMetricsRequest
     * @return A Java Future containing the result of the GetECSServiceRecommendationProjectedMetrics operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetECSServiceRecommendationProjectedMetrics
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetECSServiceRecommendationProjectedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEcsServiceRecommendationProjectedMetricsResponse> getECSServiceRecommendationProjectedMetrics(
            GetEcsServiceRecommendationProjectedMetricsRequest getEcsServiceRecommendationProjectedMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the projected metrics of Amazon ECS service recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEcsServiceRecommendationProjectedMetricsRequest.Builder} avoiding the need to create one manually via
     * {@link GetEcsServiceRecommendationProjectedMetricsRequest#builder()}
     * </p>
     *
     * @param getEcsServiceRecommendationProjectedMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetECSServiceRecommendationProjectedMetricsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetECSServiceRecommendationProjectedMetrics operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetECSServiceRecommendationProjectedMetrics
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetECSServiceRecommendationProjectedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEcsServiceRecommendationProjectedMetricsResponse> getECSServiceRecommendationProjectedMetrics(
            Consumer<GetEcsServiceRecommendationProjectedMetricsRequest.Builder> getEcsServiceRecommendationProjectedMetricsRequest) {
        return getECSServiceRecommendationProjectedMetrics(GetEcsServiceRecommendationProjectedMetricsRequest.builder()
                .applyMutation(getEcsServiceRecommendationProjectedMetricsRequest).build());
    }

    /**
     * <p>
     * Returns Amazon ECS service recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of
     * requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getEcsServiceRecommendationsRequest
     * @return A Java Future containing the result of the GetECSServiceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetECSServiceRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetECSServiceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEcsServiceRecommendationsResponse> getECSServiceRecommendations(
            GetEcsServiceRecommendationsRequest getEcsServiceRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Amazon ECS service recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of
     * requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEcsServiceRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetEcsServiceRecommendationsRequest#builder()}
     * </p>
     *
     * @param getEcsServiceRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetECSServiceRecommendationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetECSServiceRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetECSServiceRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetECSServiceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEcsServiceRecommendationsResponse> getECSServiceRecommendations(
            Consumer<GetEcsServiceRecommendationsRequest.Builder> getEcsServiceRecommendationsRequest) {
        return getECSServiceRecommendations(GetEcsServiceRecommendationsRequest.builder()
                .applyMutation(getEcsServiceRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure
     * metrics. Considers all applicable preferences that you might have set at the resource, account, and organization
     * level.
     * </p>
     * <p>
     * When you create a recommendation preference, you can set its status to <code>Active</code> or
     * <code>Inactive</code>. Use this action to view the recommendation preferences that are in effect, or
     * <code>Active</code>.
     * </p>
     *
     * @param getEffectiveRecommendationPreferencesRequest
     * @return A Java Future containing the result of the GetEffectiveRecommendationPreferences operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEffectiveRecommendationPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEffectiveRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEffectiveRecommendationPreferencesResponse> getEffectiveRecommendationPreferences(
            GetEffectiveRecommendationPreferencesRequest getEffectiveRecommendationPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure
     * metrics. Considers all applicable preferences that you might have set at the resource, account, and organization
     * level.
     * </p>
     * <p>
     * When you create a recommendation preference, you can set its status to <code>Active</code> or
     * <code>Inactive</code>. Use this action to view the recommendation preferences that are in effect, or
     * <code>Active</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEffectiveRecommendationPreferencesRequest.Builder} avoiding the need to create one manually via
     * {@link GetEffectiveRecommendationPreferencesRequest#builder()}
     * </p>
     *
     * @param getEffectiveRecommendationPreferencesRequest
     *        A {@link Consumer} that will call methods on {@link GetEffectiveRecommendationPreferencesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEffectiveRecommendationPreferences operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEffectiveRecommendationPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEffectiveRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEffectiveRecommendationPreferencesResponse> getEffectiveRecommendationPreferences(
            Consumer<GetEffectiveRecommendationPreferencesRequest.Builder> getEffectiveRecommendationPreferencesRequest) {
        return getEffectiveRecommendationPreferences(GetEffectiveRecommendationPreferencesRequest.builder()
                .applyMutation(getEffectiveRecommendationPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
     * </p>
     * <p>
     * If the account is the management account of an organization, this action also confirms the enrollment status of
     * member accounts of the organization. Use the <a>GetEnrollmentStatusesForOrganization</a> action to get detailed
     * information about the enrollment status of member accounts of an organization.
     * </p>
     *
     * @param getEnrollmentStatusRequest
     * @return A Java Future containing the result of the GetEnrollmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnrollmentStatusResponse> getEnrollmentStatus(
            GetEnrollmentStatusRequest getEnrollmentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
     * </p>
     * <p>
     * If the account is the management account of an organization, this action also confirms the enrollment status of
     * member accounts of the organization. Use the <a>GetEnrollmentStatusesForOrganization</a> action to get detailed
     * information about the enrollment status of member accounts of an organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnrollmentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnrollmentStatusRequest#builder()}
     * </p>
     *
     * @param getEnrollmentStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetEnrollmentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEnrollmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnrollmentStatusResponse> getEnrollmentStatus(
            Consumer<GetEnrollmentStatusRequest.Builder> getEnrollmentStatusRequest) {
        return getEnrollmentStatus(GetEnrollmentStatusRequest.builder().applyMutation(getEnrollmentStatusRequest).build());
    }

    /**
     * <p>
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an
     * organization management account.
     * </p>
     * <p>
     * To get the enrollment status of standalone accounts, use the <a>GetEnrollmentStatus</a> action.
     * </p>
     *
     * @param getEnrollmentStatusesForOrganizationRequest
     * @return A Java Future containing the result of the GetEnrollmentStatusesForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEnrollmentStatusesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatusesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnrollmentStatusesForOrganizationResponse> getEnrollmentStatusesForOrganization(
            GetEnrollmentStatusesForOrganizationRequest getEnrollmentStatusesForOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an
     * organization management account.
     * </p>
     * <p>
     * To get the enrollment status of standalone accounts, use the <a>GetEnrollmentStatus</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEnrollmentStatusesForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link GetEnrollmentStatusesForOrganizationRequest#builder()}
     * </p>
     *
     * @param getEnrollmentStatusesForOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link GetEnrollmentStatusesForOrganizationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetEnrollmentStatusesForOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEnrollmentStatusesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatusesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEnrollmentStatusesForOrganizationResponse> getEnrollmentStatusesForOrganization(
            Consumer<GetEnrollmentStatusesForOrganizationRequest.Builder> getEnrollmentStatusesForOrganizationRequest) {
        return getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationRequest.builder()
                .applyMutation(getEnrollmentStatusesForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an
     * organization management account.
     * </p>
     * <p>
     * To get the enrollment status of standalone accounts, use the <a>GetEnrollmentStatus</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEnrollmentStatusesForOrganization(software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetEnrollmentStatusesForOrganizationPublisher publisher = client.getEnrollmentStatusesForOrganizationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetEnrollmentStatusesForOrganizationPublisher publisher = client.getEnrollmentStatusesForOrganizationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnrollmentStatusesForOrganization(software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEnrollmentStatusesForOrganizationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEnrollmentStatusesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatusesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnrollmentStatusesForOrganizationPublisher getEnrollmentStatusesForOrganizationPaginator(
            GetEnrollmentStatusesForOrganizationRequest getEnrollmentStatusesForOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an
     * organization management account.
     * </p>
     * <p>
     * To get the enrollment status of standalone accounts, use the <a>GetEnrollmentStatus</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEnrollmentStatusesForOrganization(software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetEnrollmentStatusesForOrganizationPublisher publisher = client.getEnrollmentStatusesForOrganizationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetEnrollmentStatusesForOrganizationPublisher publisher = client.getEnrollmentStatusesForOrganizationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnrollmentStatusesForOrganization(software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetEnrollmentStatusesForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link GetEnrollmentStatusesForOrganizationRequest#builder()}
     * </p>
     *
     * @param getEnrollmentStatusesForOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link GetEnrollmentStatusesForOrganizationRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetEnrollmentStatusesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatusesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnrollmentStatusesForOrganizationPublisher getEnrollmentStatusesForOrganizationPaginator(
            Consumer<GetEnrollmentStatusesForOrganizationRequest.Builder> getEnrollmentStatusesForOrganizationRequest) {
        return getEnrollmentStatusesForOrganizationPaginator(GetEnrollmentStatusesForOrganizationRequest.builder()
                .applyMutation(getEnrollmentStatusesForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns Lambda function recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more
     * information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getLambdaFunctionRecommendationsRequest
     * @return A Java Future containing the result of the GetLambdaFunctionRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLambdaFunctionRecommendationsResponse> getLambdaFunctionRecommendations(
            GetLambdaFunctionRecommendationsRequest getLambdaFunctionRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Lambda function recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more
     * information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLambdaFunctionRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetLambdaFunctionRecommendationsRequest#builder()}
     * </p>
     *
     * @param getLambdaFunctionRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetLambdaFunctionRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLambdaFunctionRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLambdaFunctionRecommendationsResponse> getLambdaFunctionRecommendations(
            Consumer<GetLambdaFunctionRecommendationsRequest.Builder> getLambdaFunctionRecommendationsRequest) {
        return getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest.builder()
                .applyMutation(getLambdaFunctionRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns Lambda function recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more
     * information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLambdaFunctionRecommendations(software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetLambdaFunctionRecommendationsPublisher publisher = client.getLambdaFunctionRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetLambdaFunctionRecommendationsPublisher publisher = client.getLambdaFunctionRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLambdaFunctionRecommendations(software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getLambdaFunctionRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLambdaFunctionRecommendationsPublisher getLambdaFunctionRecommendationsPaginator(
            GetLambdaFunctionRecommendationsRequest getLambdaFunctionRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Lambda function recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more
     * information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getLambdaFunctionRecommendations(software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetLambdaFunctionRecommendationsPublisher publisher = client.getLambdaFunctionRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetLambdaFunctionRecommendationsPublisher publisher = client.getLambdaFunctionRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLambdaFunctionRecommendations(software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLambdaFunctionRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetLambdaFunctionRecommendationsRequest#builder()}
     * </p>
     *
     * @param getLambdaFunctionRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetLambdaFunctionRecommendationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>LimitExceededException The request exceeds a limit of the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLambdaFunctionRecommendationsPublisher getLambdaFunctionRecommendationsPaginator(
            Consumer<GetLambdaFunctionRecommendationsRequest.Builder> getLambdaFunctionRecommendationsRequest) {
        return getLambdaFunctionRecommendationsPaginator(GetLambdaFunctionRecommendationsRequest.builder()
                .applyMutation(getLambdaFunctionRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * Use the <code>scope</code> parameter to specify which preferences to return. You can specify to return
     * preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon
     * Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getRecommendationPreferencesRequest
     * @return A Java Future containing the result of the GetRecommendationPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationPreferencesResponse> getRecommendationPreferences(
            GetRecommendationPreferencesRequest getRecommendationPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * Use the <code>scope</code> parameter to specify which preferences to return. You can specify to return
     * preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon
     * Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationPreferencesRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecommendationPreferencesRequest#builder()}
     * </p>
     *
     * @param getRecommendationPreferencesRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommendationPreferencesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetRecommendationPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationPreferencesResponse> getRecommendationPreferences(
            Consumer<GetRecommendationPreferencesRequest.Builder> getRecommendationPreferencesRequest) {
        return getRecommendationPreferences(GetRecommendationPreferencesRequest.builder()
                .applyMutation(getRecommendationPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * Use the <code>scope</code> parameter to specify which preferences to return. You can specify to return
     * preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon
     * Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getRecommendationPreferences(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationPreferencesPublisher publisher = client.getRecommendationPreferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationPreferencesPublisher publisher = client.getRecommendationPreferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRecommendationPreferences(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getRecommendationPreferencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationPreferencesPublisher getRecommendationPreferencesPaginator(
            GetRecommendationPreferencesRequest getRecommendationPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * Use the <code>scope</code> parameter to specify which preferences to return. You can specify to return
     * preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon
     * Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getRecommendationPreferences(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationPreferencesPublisher publisher = client.getRecommendationPreferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationPreferencesPublisher publisher = client.getRecommendationPreferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRecommendationPreferences(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationPreferencesRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecommendationPreferencesRequest#builder()}
     * </p>
     *
     * @param getRecommendationPreferencesRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommendationPreferencesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationPreferencesPublisher getRecommendationPreferencesPaginator(
            Consumer<GetRecommendationPreferencesRequest.Builder> getRecommendationPreferencesRequest) {
        return getRecommendationPreferencesPaginator(GetRecommendationPreferencesRequest.builder()
                .applyMutation(getRecommendationPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns the optimization findings for an account.
     * </p>
     * <p>
     * It returns the number of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 instances in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Auto Scaling groups in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon EBS volumes in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda functions in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECS services in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getRecommendationSummariesRequest
     * @return A Java Future containing the result of the GetRecommendationSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationSummariesResponse> getRecommendationSummaries(
            GetRecommendationSummariesRequest getRecommendationSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the optimization findings for an account.
     * </p>
     * <p>
     * It returns the number of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 instances in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Auto Scaling groups in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon EBS volumes in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda functions in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECS services in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link GetRecommendationSummariesRequest#builder()}
     * </p>
     *
     * @param getRecommendationSummariesRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommendationSummariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRecommendationSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationSummariesResponse> getRecommendationSummaries(
            Consumer<GetRecommendationSummariesRequest.Builder> getRecommendationSummariesRequest) {
        return getRecommendationSummaries(GetRecommendationSummariesRequest.builder()
                .applyMutation(getRecommendationSummariesRequest).build());
    }

    /**
     * <p>
     * Returns the optimization findings for an account.
     * </p>
     * <p>
     * It returns the number of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 instances in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Auto Scaling groups in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon EBS volumes in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda functions in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECS services in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getRecommendationSummaries(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationSummariesPublisher publisher = client.getRecommendationSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationSummariesPublisher publisher = client.getRecommendationSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRecommendationSummaries(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getRecommendationSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationSummariesPublisher getRecommendationSummariesPaginator(
            GetRecommendationSummariesRequest getRecommendationSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the optimization findings for an account.
     * </p>
     * <p>
     * It returns the number of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 instances in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Auto Scaling groups in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon EBS volumes in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda functions in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECS services in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getRecommendationSummaries(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationSummariesPublisher publisher = client.getRecommendationSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationSummariesPublisher publisher = client.getRecommendationSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRecommendationSummaries(software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link GetRecommendationSummariesRequest#builder()}
     * </p>
     *
     * @param getRecommendationSummariesRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommendationSummariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.GetRecommendationSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationSummariesPublisher getRecommendationSummariesPaginator(
            Consumer<GetRecommendationSummariesRequest.Builder> getRecommendationSummariesRequest) {
        return getRecommendationSummariesPaginator(GetRecommendationSummariesRequest.builder()
                .applyMutation(getRecommendationSummariesRequest).build());
    }

    /**
     * <p>
     * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced
     * infrastructure metrics.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param putRecommendationPreferencesRequest
     * @return A Java Future containing the result of the PutRecommendationPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.PutRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/PutRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRecommendationPreferencesResponse> putRecommendationPreferences(
            PutRecommendationPreferencesRequest putRecommendationPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced
     * infrastructure metrics.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRecommendationPreferencesRequest.Builder}
     * avoiding the need to create one manually via {@link PutRecommendationPreferencesRequest#builder()}
     * </p>
     *
     * @param putRecommendationPreferencesRequest
     *        A {@link Consumer} that will call methods on {@link PutRecommendationPreferencesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutRecommendationPreferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OptInRequiredException The account is not opted in to Compute Optimizer.</li>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.PutRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/PutRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRecommendationPreferencesResponse> putRecommendationPreferences(
            Consumer<PutRecommendationPreferencesRequest.Builder> putRecommendationPreferencesRequest) {
        return putRecommendationPreferences(PutRecommendationPreferencesRequest.builder()
                .applyMutation(putRecommendationPreferencesRequest).build());
    }

    /**
     * <p>
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     * </p>
     * <p>
     * If the account is a management account of an organization, this action can also be used to enroll member accounts
     * of the organization.
     * </p>
     * <p>
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt
     * out. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon
     * Web Services Identity and Access Management</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its
     * data. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using
     * Service-Linked Roles for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param updateEnrollmentStatusRequest
     * @return A Java Future containing the result of the UpdateEnrollmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.UpdateEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/UpdateEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnrollmentStatusResponse> updateEnrollmentStatus(
            UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     * </p>
     * <p>
     * If the account is a management account of an organization, this action can also be used to enroll member accounts
     * of the organization.
     * </p>
     * <p>
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt
     * out. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon
     * Web Services Identity and Access Management</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its
     * data. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using
     * Service-Linked Roles for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnrollmentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEnrollmentStatusRequest#builder()}
     * </p>
     *
     * @param updateEnrollmentStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEnrollmentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEnrollmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal error has occurred. Try your call again.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterValueException The value supplied for the input parameter is out of range or not
     *         valid.</li>
     *         <li>MissingAuthenticationTokenException The request must contain either a valid (registered) Amazon Web
     *         Services access key ID or X.509 certificate.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComputeOptimizerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ComputeOptimizerAsyncClient.UpdateEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/UpdateEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnrollmentStatusResponse> updateEnrollmentStatus(
            Consumer<UpdateEnrollmentStatusRequest.Builder> updateEnrollmentStatusRequest) {
        return updateEnrollmentStatus(UpdateEnrollmentStatusRequest.builder().applyMutation(updateEnrollmentStatusRequest)
                .build());
    }

    @Override
    default ComputeOptimizerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ComputeOptimizerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ComputeOptimizerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ComputeOptimizerAsyncClient}.
     */
    static ComputeOptimizerAsyncClientBuilder builder() {
        return new DefaultComputeOptimizerAsyncClientBuilder();
    }
}
