/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityPoolUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityPoolUsage> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(IdentityPoolUsage.getter(IdentityPoolUsage::identityPoolId)).setter(IdentityPoolUsage.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<Long> SYNC_SESSIONS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SyncSessionsCount").getter(IdentityPoolUsage.getter(IdentityPoolUsage::syncSessionsCount)).setter(IdentityPoolUsage.setter(Builder::syncSessionsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSessionsCount").build()}).build();
    private static final SdkField<Long> DATA_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataStorage").getter(IdentityPoolUsage.getter(IdentityPoolUsage::dataStorage)).setter(IdentityPoolUsage.setter(Builder::dataStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorage").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(IdentityPoolUsage.getter(IdentityPoolUsage::lastModifiedDate)).setter(IdentityPoolUsage.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, SYNC_SESSIONS_COUNT_FIELD, DATA_STORAGE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identityPoolId;
    private final Long syncSessionsCount;
    private final Long dataStorage;
    private final Instant lastModifiedDate;

    private IdentityPoolUsage(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.syncSessionsCount = builder.syncSessionsCount;
        this.dataStorage = builder.dataStorage;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final Long syncSessionsCount() {
        return this.syncSessionsCount;
    }

    public final Long dataStorage() {
        return this.dataStorage;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSessionsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityPoolUsage)) {
            return false;
        }
        IdentityPoolUsage other = (IdentityPoolUsage)obj;
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.syncSessionsCount(), other.syncSessionsCount()) && Objects.equals(this.dataStorage(), other.dataStorage()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityPoolUsage").add("IdentityPoolId", (Object)this.identityPoolId()).add("SyncSessionsCount", (Object)this.syncSessionsCount()).add("DataStorage", (Object)this.dataStorage()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "SyncSessionsCount": {
                return Optional.ofNullable(clazz.cast(this.syncSessionsCount()));
            }
            case "DataStorage": {
                return Optional.ofNullable(clazz.cast(this.dataStorage()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityPoolUsage, T> g) {
        return obj -> g.apply((IdentityPoolUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Long syncSessionsCount;
        private Long dataStorage;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityPoolUsage model) {
            this.identityPoolId(model.identityPoolId);
            this.syncSessionsCount(model.syncSessionsCount);
            this.dataStorage(model.dataStorage);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final Long getSyncSessionsCount() {
            return this.syncSessionsCount;
        }

        public final void setSyncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
        }

        @Override
        public final Builder syncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
            return this;
        }

        public final Long getDataStorage() {
            return this.dataStorage;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public IdentityPoolUsage build() {
            return new IdentityPoolUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityPoolUsage> {
        public Builder identityPoolId(String var1);

        public Builder syncSessionsCount(Long var1);

        public Builder dataStorage(Long var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

