/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contextual user data type used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContextDataType implements SdkPojo, Serializable, ToCopyableBuilder<ContextDataType.Builder, ContextDataType> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(ContextDataType::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(ContextDataType::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> SERVER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerPath").getter(getter(ContextDataType::serverPath)).setter(setter(Builder::serverPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPath").build()).build();

    private static final SdkField<List<HttpHeader>> HTTP_HEADERS_FIELD = SdkField
            .<List<HttpHeader>> builder(MarshallingType.LIST)
            .memberName("HttpHeaders")
            .getter(getter(ContextDataType::httpHeaders))
            .setter(setter(Builder::httpHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENCODED_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncodedData").getter(getter(ContextDataType::encodedData)).setter(setter(Builder::encodedData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodedData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD,
            SERVER_NAME_FIELD, SERVER_PATH_FIELD, HTTP_HEADERS_FIELD, ENCODED_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String serverName;

    private final String serverPath;

    private final List<HttpHeader> httpHeaders;

    private final String encodedData;

    private ContextDataType(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.serverName = builder.serverName;
        this.serverPath = builder.serverPath;
        this.httpHeaders = builder.httpHeaders;
        this.encodedData = builder.encodedData;
    }

    /**
     * <p>
     * The source IP address of your user's device.
     * </p>
     * 
     * @return The source IP address of your user's device.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Your server endpoint where this API is invoked.
     * </p>
     * 
     * @return Your server endpoint where this API is invoked.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * Your server path where this API is invoked.
     * </p>
     * 
     * @return Your server path where this API is invoked.
     */
    public final String serverPath() {
        return serverPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the HttpHeaders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHttpHeaders() {
        return httpHeaders != null && !(httpHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * HttpHeaders received on your server in same order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHttpHeaders} method.
     * </p>
     * 
     * @return HttpHeaders received on your server in same order.
     */
    public final List<HttpHeader> httpHeaders() {
        return httpHeaders;
    }

    /**
     * <p>
     * Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection
     * library. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
     * >Adding user device and session data to API requests</a>.
     * </p>
     * 
     * @return Encoded device-fingerprint details that your app collected with the Amazon Cognito context data
     *         collection library. For more information, see <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
     *         >Adding user device and session data to API requests</a>.
     */
    public final String encodedData() {
        return encodedData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(serverPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasHttpHeaders() ? httpHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encodedData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextDataType)) {
            return false;
        }
        ContextDataType other = (ContextDataType) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(serverPath(), other.serverPath()) && hasHttpHeaders() == other.hasHttpHeaders()
                && Objects.equals(httpHeaders(), other.httpHeaders()) && Objects.equals(encodedData(), other.encodedData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContextDataType").add("IpAddress", ipAddress()).add("ServerName", serverName())
                .add("ServerPath", serverPath()).add("HttpHeaders", hasHttpHeaders() ? httpHeaders() : null)
                .add("EncodedData", encodedData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "ServerPath":
            return Optional.ofNullable(clazz.cast(serverPath()));
        case "HttpHeaders":
            return Optional.ofNullable(clazz.cast(httpHeaders()));
        case "EncodedData":
            return Optional.ofNullable(clazz.cast(encodedData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContextDataType, T> g) {
        return obj -> g.apply((ContextDataType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContextDataType> {
        /**
         * <p>
         * The source IP address of your user's device.
         * </p>
         * 
         * @param ipAddress
         *        The source IP address of your user's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Your server endpoint where this API is invoked.
         * </p>
         * 
         * @param serverName
         *        Your server endpoint where this API is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * Your server path where this API is invoked.
         * </p>
         * 
         * @param serverPath
         *        Your server path where this API is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPath(String serverPath);

        /**
         * <p>
         * HttpHeaders received on your server in same order.
         * </p>
         * 
         * @param httpHeaders
         *        HttpHeaders received on your server in same order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpHeaders(Collection<HttpHeader> httpHeaders);

        /**
         * <p>
         * HttpHeaders received on your server in same order.
         * </p>
         * 
         * @param httpHeaders
         *        HttpHeaders received on your server in same order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpHeaders(HttpHeader... httpHeaders);

        /**
         * <p>
         * HttpHeaders received on your server in same order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader.Builder#build()} is called
         * immediately and its result is passed to {@link #httpHeaders(List<HttpHeader>)}.
         * 
         * @param httpHeaders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.HttpHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpHeaders(java.util.Collection<HttpHeader>)
         */
        Builder httpHeaders(Consumer<HttpHeader.Builder>... httpHeaders);

        /**
         * <p>
         * Encoded device-fingerprint details that your app collected with the Amazon Cognito context data collection
         * library. For more information, see <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
         * >Adding user device and session data to API requests</a>.
         * </p>
         * 
         * @param encodedData
         *        Encoded device-fingerprint details that your app collected with the Amazon Cognito context data
         *        collection library. For more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint"
         *        >Adding user device and session data to API requests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodedData(String encodedData);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String serverName;

        private String serverPath;

        private List<HttpHeader> httpHeaders = DefaultSdkAutoConstructList.getInstance();

        private String encodedData;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextDataType model) {
            ipAddress(model.ipAddress);
            serverName(model.serverName);
            serverPath(model.serverPath);
            httpHeaders(model.httpHeaders);
            encodedData(model.encodedData);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getServerPath() {
            return serverPath;
        }

        public final void setServerPath(String serverPath) {
            this.serverPath = serverPath;
        }

        @Override
        public final Builder serverPath(String serverPath) {
            this.serverPath = serverPath;
            return this;
        }

        public final List<HttpHeader.Builder> getHttpHeaders() {
            List<HttpHeader.Builder> result = HttpHeaderListCopier.copyToBuilder(this.httpHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHttpHeaders(Collection<HttpHeader.BuilderImpl> httpHeaders) {
            this.httpHeaders = HttpHeaderListCopier.copyFromBuilder(httpHeaders);
        }

        @Override
        public final Builder httpHeaders(Collection<HttpHeader> httpHeaders) {
            this.httpHeaders = HttpHeaderListCopier.copy(httpHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpHeaders(HttpHeader... httpHeaders) {
            httpHeaders(Arrays.asList(httpHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpHeaders(Consumer<HttpHeader.Builder>... httpHeaders) {
            httpHeaders(Stream.of(httpHeaders).map(c -> HttpHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEncodedData() {
            return encodedData;
        }

        public final void setEncodedData(String encodedData) {
            this.encodedData = encodedData;
        }

        @Override
        public final Builder encodedData(String encodedData) {
            this.encodedData = encodedData;
            return this;
        }

        @Override
        public ContextDataType build() {
            return new ContextDataType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
