/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityPoolsResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, ListIdentityPoolsResponse> {
    private static final SdkField<List<IdentityPoolShortDescription>> IDENTITY_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityPools").getter(ListIdentityPoolsResponse.getter(ListIdentityPoolsResponse::identityPools)).setter(ListIdentityPoolsResponse.setter(Builder::identityPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityPoolShortDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIdentityPoolsResponse.getter(ListIdentityPoolsResponse::nextToken)).setter(ListIdentityPoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IdentityPoolShortDescription> identityPools;
    private final String nextToken;

    private ListIdentityPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.identityPools = builder.identityPools;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIdentityPools() {
        return this.identityPools != null && !(this.identityPools instanceof SdkAutoConstructList);
    }

    public final List<IdentityPoolShortDescription> identityPools() {
        return this.identityPools;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityPools() ? this.identityPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResponse)) {
            return false;
        }
        ListIdentityPoolsResponse other = (ListIdentityPoolsResponse)((Object)obj);
        return this.hasIdentityPools() == other.hasIdentityPools() && Objects.equals(this.identityPools(), other.identityPools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIdentityPoolsResponse").add("IdentityPools", this.hasIdentityPools() ? this.identityPools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPools": {
                return Optional.ofNullable(clazz.cast(this.identityPools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityPoolsResponse, T> g) {
        return obj -> g.apply((ListIdentityPoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private List<IdentityPoolShortDescription> identityPools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolsResponse model) {
            super(model);
            this.identityPools(model.identityPools);
            this.nextToken(model.nextToken);
        }

        public final List<IdentityPoolShortDescription.Builder> getIdentityPools() {
            List<IdentityPoolShortDescription.Builder> result = IdentityPoolsListCopier.copyToBuilder(this.identityPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityPools(Collection<IdentityPoolShortDescription.BuilderImpl> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copyFromBuilder(identityPools);
        }

        @Override
        public final Builder identityPools(Collection<IdentityPoolShortDescription> identityPools) {
            this.identityPools = IdentityPoolsListCopier.copy(identityPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(IdentityPoolShortDescription ... identityPools) {
            this.identityPools(Arrays.asList(identityPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPools(Consumer<IdentityPoolShortDescription.Builder> ... identityPools) {
            this.identityPools(Stream.of(identityPools).map(c -> (IdentityPoolShortDescription)((IdentityPoolShortDescription.Builder)IdentityPoolShortDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityPoolsResponse build() {
            return new ListIdentityPoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentityPoolsResponse> {
        public Builder identityPools(Collection<IdentityPoolShortDescription> var1);

        public Builder identityPools(IdentityPoolShortDescription ... var1);

        public Builder identityPools(Consumer<IdentityPoolShortDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

