/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to a ListIdentities request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentitiesResponse extends CognitoIdentityResponse implements
        ToCopyableBuilder<ListIdentitiesResponse.Builder, ListIdentitiesResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(ListIdentitiesResponse::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<List<IdentityDescription>> IDENTITIES_FIELD = SdkField
            .<List<IdentityDescription>> builder(MarshallingType.LIST)
            .memberName("Identities")
            .getter(getter(ListIdentitiesResponse::identities))
            .setter(setter(Builder::identities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIdentitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITIES_FIELD, NEXT_TOKEN_FIELD));

    private final String identityPoolId;

    private final List<IdentityDescription> identities;

    private final String nextToken;

    private ListIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identities = builder.identities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIdentities() {
        return identities != null && !(identities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object containing a set of identities and associated mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentities} method.
     * </p>
     * 
     * @return An object containing a set of identities and associated mappings.
     */
    public final List<IdentityDescription> identities() {
        return identities;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentities() ? identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResponse)) {
            return false;
        }
        ListIdentitiesResponse other = (ListIdentitiesResponse) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && hasIdentities() == other.hasIdentities()
                && Objects.equals(identities(), other.identities()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentitiesResponse").add("IdentityPoolId", identityPoolId())
                .add("Identities", hasIdentities() ? identities() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "Identities":
            return Optional.ofNullable(clazz.cast(identities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentitiesResponse, T> g) {
        return obj -> g.apply((ListIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIdentitiesResponse> {
        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * 
         * @param identities
         *        An object containing a set of identities and associated mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Collection<IdentityDescription> identities);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * 
         * @param identities
         *        An object containing a set of identities and associated mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(IdentityDescription... identities);

        /**
         * <p>
         * An object containing a set of identities and associated mappings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #identities(List<IdentityDescription>)}.
         * 
         * @param identities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identities(java.util.Collection<IdentityDescription>)
         */
        Builder identities(Consumer<IdentityDescription.Builder>... identities);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityResponse.BuilderImpl implements Builder {
        private String identityPoolId;

        private List<IdentityDescription> identities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesResponse model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identities(model.identities);
            nextToken(model.nextToken);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final List<IdentityDescription.Builder> getIdentities() {
            List<IdentityDescription.Builder> result = IdentitiesListCopier.copyToBuilder(this.identities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentities(Collection<IdentityDescription.BuilderImpl> identities) {
            this.identities = IdentitiesListCopier.copyFromBuilder(identities);
        }

        @Override
        public final Builder identities(Collection<IdentityDescription> identities) {
            this.identities = IdentitiesListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(IdentityDescription... identities) {
            identities(Arrays.asList(identities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(Consumer<IdentityDescription.Builder>... identities) {
            identities(Stream.of(identities).map(c -> IdentityDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentitiesResponse build() {
            return new ListIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
