/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectionsRequest extends CodeStarConnectionsRequest implements
        ToCopyableBuilder<ListConnectionsRequest.Builder, ListConnectionsRequest> {
    private static final SdkField<String> PROVIDER_TYPE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderTypeFilter").getter(getter(ListConnectionsRequest::providerTypeFilterAsString))
            .setter(setter(Builder::providerTypeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderTypeFilter").build())
            .build();

    private static final SdkField<String> HOST_ARN_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostArnFilter").getter(getter(ListConnectionsRequest::hostArnFilter))
            .setter(setter(Builder::hostArnFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostArnFilter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListConnectionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConnectionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPE_FILTER_FIELD,
            HOST_ARN_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String providerTypeFilter;

    private final String hostArnFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.providerTypeFilter = builder.providerTypeFilter;
        this.hostArnFilter = builder.hostArnFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #providerTypeFilter} will return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #providerTypeFilterAsString}.
     * </p>
     * 
     * @return Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * @see ProviderType
     */
    public final ProviderType providerTypeFilter() {
        return ProviderType.fromValue(providerTypeFilter);
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #providerTypeFilter} will return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #providerTypeFilterAsString}.
     * </p>
     * 
     * @return Filters the list of connections to those associated with a specified provider, such as Bitbucket.
     * @see ProviderType
     */
    public final String providerTypeFilterAsString() {
        return providerTypeFilter;
    }

    /**
     * <p>
     * Filters the list of connections to those associated with a specified host.
     * </p>
     * 
     * @return Filters the list of connections to those associated with a specified host.
     */
    public final String hostArnFilter() {
        return hostArnFilter;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token that was returned from the previous <code>ListConnections</code> call, which can be used to return the
     * next set of connections in the list.
     * </p>
     * 
     * @return The token that was returned from the previous <code>ListConnections</code> call, which can be used to
     *         return the next set of connections in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostArnFilter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionsRequest)) {
            return false;
        }
        ListConnectionsRequest other = (ListConnectionsRequest) obj;
        return Objects.equals(providerTypeFilterAsString(), other.providerTypeFilterAsString())
                && Objects.equals(hostArnFilter(), other.hostArnFilter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectionsRequest").add("ProviderTypeFilter", providerTypeFilterAsString())
                .add("HostArnFilter", hostArnFilter()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderTypeFilter":
            return Optional.ofNullable(clazz.cast(providerTypeFilterAsString()));
        case "HostArnFilter":
            return Optional.ofNullable(clazz.cast(hostArnFilter()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionsRequest, T> g) {
        return obj -> g.apply((ListConnectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConnectionsRequest> {
        /**
         * <p>
         * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
         * </p>
         * 
         * @param providerTypeFilter
         *        Filters the list of connections to those associated with a specified provider, such as Bitbucket.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerTypeFilter(String providerTypeFilter);

        /**
         * <p>
         * Filters the list of connections to those associated with a specified provider, such as Bitbucket.
         * </p>
         * 
         * @param providerTypeFilter
         *        Filters the list of connections to those associated with a specified provider, such as Bitbucket.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerTypeFilter(ProviderType providerTypeFilter);

        /**
         * <p>
         * Filters the list of connections to those associated with a specified host.
         * </p>
         * 
         * @param hostArnFilter
         *        Filters the list of connections to those associated with a specified host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostArnFilter(String hostArnFilter);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token that was returned from the previous <code>ListConnections</code> call, which can be used to return
         * the next set of connections in the list.
         * </p>
         * 
         * @param nextToken
         *        The token that was returned from the previous <code>ListConnections</code> call, which can be used to
         *        return the next set of connections in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarConnectionsRequest.BuilderImpl implements Builder {
        private String providerTypeFilter;

        private String hostArnFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionsRequest model) {
            super(model);
            providerTypeFilter(model.providerTypeFilter);
            hostArnFilter(model.hostArnFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getProviderTypeFilter() {
            return providerTypeFilter;
        }

        public final void setProviderTypeFilter(String providerTypeFilter) {
            this.providerTypeFilter = providerTypeFilter;
        }

        @Override
        public final Builder providerTypeFilter(String providerTypeFilter) {
            this.providerTypeFilter = providerTypeFilter;
            return this;
        }

        @Override
        public final Builder providerTypeFilter(ProviderType providerTypeFilter) {
            this.providerTypeFilter(providerTypeFilter == null ? null : providerTypeFilter.toString());
            return this;
        }

        public final String getHostArnFilter() {
            return hostArnFilter;
        }

        public final void setHostArnFilter(String hostArnFilter) {
            this.hostArnFilter = hostArnFilter;
        }

        @Override
        public final Builder hostArnFilter(String hostArnFilter) {
            this.hostArnFilter = hostArnFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectionsRequest build() {
            return new ListConnectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
